/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateStatement
implements Statement {
    private VariableExpr vars;
    private Expression target;
    private Expression condition;
    private List<UpdateClause> ucs;

    public UpdateStatement(VariableExpr vars, Expression target, Expression condition, List<UpdateClause> ucs) {
        this.vars = vars;
        this.target = target;
        this.condition = condition;
        this.ucs = ucs;
    }

    @Override
    public byte getKind() {
        return 7;
    }

    public VariableExpr getVariableExpr() {
        return this.vars;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public List<UpdateClause> getUpdateClauses() {
        return this.ucs;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.condition, this.target, this.ucs, this.vars});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UpdateStatement)) {
            return false;
        }
        UpdateStatement update = (UpdateStatement)object;
        return ObjectUtils.equals((Object)this.condition, (Object)update.condition) && ObjectUtils.equals((Object)this.target, (Object)update.target) && ObjectUtils.equals(this.ucs, update.ucs) && ObjectUtils.equals((Object)this.vars, (Object)update.vars);
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

