/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class InsertStatement
implements IReturningStatement {
    private final Identifier dataverseName;
    private final Identifier datasetName;
    private final Query query;
    private final VariableExpr var;
    private Expression returnExpression;
    private int varCounter;

    public InsertStatement(Identifier dataverseName, Identifier datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.query = query;
        this.varCounter = varCounter;
        this.var = var;
        this.returnExpression = returnExpression;
    }

    @Override
    public byte getKind() {
        return 5;
    }

    public Identifier getDataverseName() {
        return this.dataverseName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getVarCounter() {
        return this.varCounter;
    }

    @Override
    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    @Override
    public List<Expression> getDirectlyEnclosedExpressions() {
        ArrayList<Expression> topLevelExpressions = new ArrayList<Expression>();
        topLevelExpressions.add(this.query.getBody());
        if (this.returnExpression != null) {
            topLevelExpressions.add(this.returnExpression);
        }
        return topLevelExpressions;
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public Expression getBody() {
        return this.query.getBody();
    }

    @Override
    public void setBody(Expression body) {
        this.query.setBody(body);
    }

    public VariableExpr getVar() {
        return this.var;
    }

    public Expression getReturnExpression() {
        return this.returnExpression;
    }

    public void setReturnExpression(Expression expr) {
        this.returnExpression = expr;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.datasetName, this.dataverseName, this.query, this.varCounter, this.var, this.returnExpression});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InsertStatement)) {
            return false;
        }
        InsertStatement target = (InsertStatement)object;
        return ObjectUtils.equals((Object)this.datasetName, (Object)target.datasetName) && ObjectUtils.equals((Object)this.dataverseName, (Object)target.dataverseName) && ObjectUtils.equals((Object)this.query, (Object)target.query) && ObjectUtils.equals((Object)this.varCounter, (Object)target.varCounter) && ObjectUtils.equals((Object)this.var, (Object)target.var) && ObjectUtils.equals((Object)this.returnExpression, (Object)target.returnExpression);
    }

    @Override
    public byte getCategory() {
        if (this.var == null) {
            return 2;
        }
        return 1;
    }
}

