/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.context.FunctionSignatures;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;

public final class Scope {
    private Scope parent;
    private Map<String, Identifier> symbols = new HashMap<String, Identifier>();
    private Map<String, Expression> varExprMap = new HashMap<String, Expression>();
    private FunctionSignatures functionSignatures = null;
    private final ScopeChecker scopeChecker;
    private boolean maskParentScope = false;

    public Scope(ScopeChecker scopeChecker, Scope parent) {
        this.scopeChecker = scopeChecker;
        this.parent = parent;
    }

    public Scope(ScopeChecker scopeChecker) {
        this(scopeChecker, null);
    }

    public Scope(ScopeChecker scopeChecker, Scope parent, boolean maskParentScope) {
        this(scopeChecker, parent);
        this.maskParentScope = maskParentScope;
    }

    public Identifier findSymbol(String name) {
        Identifier ident = this.symbols.get(name);
        if (ident == null && !this.maskParentScope && this.parent != null) {
            ident = this.parent.findSymbol(name);
        }
        return ident;
    }

    public Identifier findLocalSymbol(String name) {
        return this.symbols.get(name);
    }

    public void addSymbolToScope(Identifier ident) {
        this.symbols.put(ident.getValue(), ident);
    }

    public void addSymbolExpressionMappingToScope(VariableExpr ident, Expression expr) {
        this.varExprMap.put(ident.getVar().getValue(), expr);
    }

    public Expression removeSymbolExpressionMapping(VariableExpr ident) {
        if (ident == null) {
            return null;
        }
        return this.varExprMap.remove(ident.getVar().getValue());
    }

    public VariableSubstitutionEnvironment getVarSubstitutionEnvironment() {
        VariableSubstitutionEnvironment env = new VariableSubstitutionEnvironment();
        env.addMappings(this.varExprMap);
        return env;
    }

    public void addNewVarSymbolToScope(VarIdentifier ident) {
        this.scopeChecker.incVarCounter();
        ident.setId(this.scopeChecker.getVarCounter());
        this.addSymbolToScope(ident);
    }

    public void addFunctionDescriptor(FunctionSignature signature, boolean varargs) {
        if (this.functionSignatures == null) {
            this.functionSignatures = new FunctionSignatures();
        }
        this.functionSignatures.put(signature, varargs);
    }

    public FunctionSignature findFunctionSignature(String dataverse, String name, int arity) {
        FunctionSignature fd = null;
        if (this.functionSignatures != null) {
            fd = this.functionSignatures.get(dataverse, name, arity);
        }
        if (fd == null && this.parent != null) {
            fd = this.parent.findFunctionSignature(dataverse, name, arity);
        }
        return fd;
    }

    public void merge(Scope scope) {
        this.symbols.putAll(scope.symbols);
        if (this.functionSignatures != null && scope.functionSignatures != null) {
            this.functionSignatures.addAll(scope.functionSignatures);
        }
        this.varExprMap.putAll(scope.varExprMap);
    }

    public Iterator<Identifier> liveSymbols() {
        final Iterator<Identifier> identifierIterator = this.symbols.values().iterator();
        final Iterator<Identifier> parentIterator = this.parent == null ? null : this.parent.liveSymbols();
        return new Iterator<Identifier>(){
            private Identifier currentSymbol = null;

            @Override
            public boolean hasNext() {
                this.currentSymbol = null;
                if (identifierIterator != null && identifierIterator.hasNext()) {
                    this.currentSymbol = (Identifier)identifierIterator.next();
                } else if (!Scope.this.maskParentScope && parentIterator != null && parentIterator.hasNext()) {
                    do {
                        Identifier symbolFromParent = (Identifier)parentIterator.next();
                        if (Scope.this.symbols.containsKey(symbolFromParent.getValue())) continue;
                        this.currentSymbol = symbolFromParent;
                        break;
                    } while (parentIterator.hasNext());
                }
                return this.currentSymbol != null;
            }

            @Override
            public Identifier next() {
                if (this.currentSymbol == null) {
                    throw new IllegalStateException("Please make sure that hasNext() returns true before calling next().");
                }
                return this.currentSymbol;
            }
        };
    }

    public Set<VariableExpr> getLiveVariables() {
        HashSet<VariableExpr> vars = new HashSet<VariableExpr>();
        Iterator<Identifier> identifierIterator = this.liveSymbols();
        while (identifierIterator.hasNext()) {
            Identifier identifier = identifierIterator.next();
            if (!(identifier instanceof VarIdentifier)) continue;
            vars.add(new VariableExpr((VarIdentifier)identifier));
        }
        return vars;
    }

    public Set<String> getLocalSymbols() {
        return this.symbols.keySet();
    }

    public Scope getParentScope() {
        return this.parent;
    }
}

