/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.AbstractFeedFetcher;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class HttpURLFeedFetcher
extends AbstractFeedFetcher {
    static final int POLL_EVENT = 1;
    static final int RETRIEVE_EVENT = 2;
    static final int UNCHANGED_EVENT = 3;
    private FeedFetcherCache feedInfoCache;

    public HttpURLFeedFetcher() {
    }

    public HttpURLFeedFetcher(FeedFetcherCache feedInfoCache) {
        this();
        this.setFeedInfoCache(feedInfoCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyndFeed retrieveFeed(URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        URLConnection connection = feedUrl.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException(feedUrl.toExternalForm() + " is not a valid HTTP Url");
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        FeedFetcherCache cache = this.getFeedInfoCache();
        if (cache != null) {
            SyndFeedInfo syndFeedInfo = cache.getFeedInfo(feedUrl);
            this.setRequestHeaders(connection, syndFeedInfo);
            httpConnection.connect();
            try {
                this.fireEvent("FEED_POLLED", connection);
                if (syndFeedInfo == null) {
                    syndFeedInfo = new SyndFeedInfo();
                    this.retrieveAndCacheFeed(feedUrl, syndFeedInfo, httpConnection);
                } else {
                    int responseCode = httpConnection.getResponseCode();
                    if (responseCode != 304) {
                        this.retrieveAndCacheFeed(feedUrl, syndFeedInfo, httpConnection);
                    } else {
                        this.fireEvent("FEED_UNCHANGED", connection);
                    }
                }
                SyndFeed responseCode = syndFeedInfo.getSyndFeed();
                return responseCode;
            }
            finally {
                httpConnection.disconnect();
            }
        }
        this.fireEvent("FEED_POLLED", connection);
        InputStream inputStream = null;
        this.setRequestHeaders(connection, null);
        httpConnection.connect();
        try {
            inputStream = httpConnection.getInputStream();
            SyndFeed responseCode = this.getSyndFeedFromStream(inputStream, connection);
            return responseCode;
        }
        catch (IOException e) {
            this.handleErrorCodes(((HttpURLConnection)connection).getResponseCode());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            httpConnection.disconnect();
        }
        return null;
    }

    protected void retrieveAndCacheFeed(URL feedUrl, SyndFeedInfo syndFeedInfo, HttpURLConnection connection) throws IllegalArgumentException, FeedException, FetcherException, IOException {
        this.handleErrorCodes(connection.getResponseCode());
        this.resetFeedInfo(feedUrl, syndFeedInfo, connection);
        FeedFetcherCache cache = this.getFeedInfoCache();
        if (cache != null) {
            cache.setFeedInfo(feedUrl, syndFeedInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetFeedInfo(URL orignalUrl, SyndFeedInfo syndFeedInfo, HttpURLConnection connection) throws IllegalArgumentException, IOException, FeedException {
        syndFeedInfo.setUrl(connection.getURL());
        syndFeedInfo.setId(orignalUrl.toString());
        syndFeedInfo.setLastModified(new Long(connection.getLastModified()));
        syndFeedInfo.setETag(connection.getHeaderField("ETag"));
        InputStream inputStream = null;
        try {
            SyndFeedInfo cachedInfo;
            FeedFetcherCache cache;
            inputStream = connection.getInputStream();
            SyndFeed syndFeed = this.getSyndFeedFromStream(inputStream, connection);
            String imHeader = connection.getHeaderField("IM");
            if (this.isUsingDeltaEncoding() && imHeader != null && imHeader.indexOf("feed") >= 0 && (cache = this.getFeedInfoCache()) != null && connection.getResponseCode() == 226 && (cachedInfo = cache.getFeedInfo(orignalUrl)) != null) {
                SyndFeed cachedFeed = cachedInfo.getSyndFeed();
                syndFeed = HttpURLFeedFetcher.combineFeeds(cachedFeed, syndFeed);
            }
            syndFeedInfo.setSyndFeed(syndFeed);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void setRequestHeaders(URLConnection connection, SyndFeedInfo syndFeedInfo) {
        if (syndFeedInfo != null) {
            Object lastModified;
            if (syndFeedInfo.getLastModified() != null && (lastModified = syndFeedInfo.getLastModified()) instanceof Long) {
                connection.setIfModifiedSince((Long)syndFeedInfo.getLastModified());
            }
            if (syndFeedInfo.getETag() != null) {
                connection.setRequestProperty("If-None-Match", syndFeedInfo.getETag());
            }
        }
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.addRequestProperty("User-Agent", this.getUserAgent());
        if (this.isUsingDeltaEncoding()) {
            connection.addRequestProperty("A-IM", "feed");
        }
    }

    private SyndFeed readSyndFeedFromStream(InputStream inputStream, URLConnection connection) throws IOException, IllegalArgumentException, FeedException {
        BufferedInputStream is = "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(inputStream)) : new BufferedInputStream(inputStream);
        XmlReader reader = null;
        reader = connection.getHeaderField("Content-Type") != null ? new XmlReader((InputStream)is, connection.getHeaderField("Content-Type"), true) : new XmlReader((InputStream)is, true);
        SyndFeedInput syndFeedInput = new SyndFeedInput();
        syndFeedInput.setPreserveWireFeed(this.isPreserveWireFeed());
        return syndFeedInput.build((Reader)reader);
    }

    private SyndFeed getSyndFeedFromStream(InputStream inputStream, URLConnection connection) throws IOException, IllegalArgumentException, FeedException {
        SyndFeed feed = this.readSyndFeedFromStream(inputStream, connection);
        this.fireEvent("FEED_RETRIEVED", connection, feed);
        return feed;
    }

    public synchronized FeedFetcherCache getFeedInfoCache() {
        return this.feedInfoCache;
    }

    public synchronized void setFeedInfoCache(FeedFetcherCache cache) {
        this.feedInfoCache = cache;
    }
}

