/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelReadInterface;

public class FullFrameChannelReadInterface
extends AbstractChannelReadInterface {
    private final Deque<ByteBuffer> riEmptyStack;
    private final IChannelControlBlock ccb;

    FullFrameChannelReadInterface(IChannelControlBlock ccb) {
        this.ccb = ccb;
        this.riEmptyStack = new ArrayDeque<ByteBuffer>();
        this.credits = 0;
        this.emptyBufferAcceptor = buffer -> {
            int delta = buffer.remaining();
            IChannelControlBlock iChannelControlBlock = ccb;
            synchronized (iChannelControlBlock) {
                if (ccb.isRemotelyClosed()) {
                    return;
                }
                this.riEmptyStack.push(buffer);
            }
            ccb.addPendingCredits(delta);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(SocketChannel sc, int size) throws IOException, NetException {
        while (size > 0) {
            int rSize;
            if (this.currentReadBuffer == null) {
                this.currentReadBuffer = this.riEmptyStack.poll();
                if (this.currentReadBuffer == null) {
                    this.currentReadBuffer = this.bufferFactory.createBuffer();
                }
            }
            if ((rSize = Math.min(size, this.currentReadBuffer.remaining())) > 0) {
                int len;
                this.currentReadBuffer.limit(this.currentReadBuffer.position() + rSize);
                try {
                    len = sc.read(this.currentReadBuffer);
                    if (len < 0) {
                        throw new NetException("Socket Closed");
                    }
                }
                finally {
                    this.currentReadBuffer.limit(this.currentReadBuffer.capacity());
                }
                size -= len;
                if (len < rSize) {
                    return size;
                }
            } else {
                return size;
            }
            if (this.currentReadBuffer.remaining() > 0) continue;
            this.flush();
        }
        return size;
    }

    @Override
    public void setBufferFactory(IBufferFactory bufferFactory, int limit, int frameSize) {
        super.setBufferFactory(bufferFactory, limit, frameSize);
        this.ccb.addPendingCredits(limit * frameSize);
    }
}

