/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;

public final class TranslationContext
implements IVariableContext {
    private Counter varCounter;
    private Stack<Map<Integer, LogicalVariable>> stack = new Stack();
    private Map<Integer, LogicalVariable> currentVarMap = new HashMap<Integer, LogicalVariable>();
    private boolean topFlwor = true;

    public TranslationContext(Counter varCounter) {
        this.varCounter = varCounter;
    }

    public int getVarCounter() {
        return this.varCounter.get();
    }

    public LogicalVariable newVar() {
        this.varCounter.inc();
        LogicalVariable var = new LogicalVariable(this.varCounter.get());
        this.currentVarMap.put(this.varCounter.get(), var);
        return var;
    }

    public void setVarCounter(int count) {
        this.varCounter.set(count);
    }

    public boolean isTopFlwor() {
        return this.topFlwor;
    }

    public void setTopFlwor(boolean b) {
        this.topFlwor = b;
    }

    public LogicalVariable getVar(Integer varId) {
        return this.currentVarMap.get(varId);
    }

    public LogicalVariable getVar(VariableExpr v) {
        return this.currentVarMap.get(v.getVar().getId());
    }

    public LogicalVariable newVar(VariableExpr v) {
        Integer i = v.getVar().getId();
        if (i > this.varCounter.get()) {
            this.varCounter.set(i.intValue());
        }
        LogicalVariable var = new LogicalVariable(i.intValue());
        this.currentVarMap.put(i, var);
        return var;
    }

    public void setVar(VariableExpr v, LogicalVariable var) {
        this.currentVarMap.put(v.getVar().getId(), var);
    }

    public void enterSubplan() {
        HashMap<Integer, LogicalVariable> varMap = new HashMap<Integer, LogicalVariable>();
        varMap.putAll(this.currentVarMap);
        this.stack.push(this.currentVarMap);
        this.currentVarMap = varMap;
    }

    public void exitSubplan() {
        if (!this.stack.isEmpty()) {
            this.currentVarMap = this.stack.pop();
        }
    }

    public LogicalVariable newSubplanOutputVar() {
        LogicalVariable newVar = this.newVar();
        if (!this.stack.isEmpty()) {
            Map<Integer, LogicalVariable> varMap = this.stack.peek();
            varMap.put(this.varCounter.get(), newVar);
        }
        return newVar;
    }
}

