/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;

public class SessionConfig {
    public static final String OOB_HYRACKS_JOB = "oob-hyracks-job";
    public static final String OOB_EXPR_TREE = "oob-expr-tree";
    public static final String OOB_REWRITTEN_EXPR_TREE = "oob-rewritten-expr-tree";
    public static final String OOB_LOGICAL_PLAN = "oob-logical-plan";
    public static final String OOB_OPTIMIZED_LOGICAL_PLAN = "oob-optimized-logical-plan";
    public static final String FORMAT_ONLY_PHYSICAL_OPS = "format-only-physical-ops";
    public static final String FORMAT_HTML = "format-html";
    public static final String FORMAT_CSV_HEADER = "format-csv-header";
    public static final String FORMAT_WRAPPER_ARRAY = "format-wrapper-array";
    public static final String FORMAT_INDENT_JSON = "indent-json";
    public static final String FORMAT_QUOTE_RECORD = "quote-record";
    private final boolean executeQuery;
    private final boolean generateJobSpec;
    private final boolean optimize;
    private final PrintWriter out;
    private final OutputFormat fmt;
    private final ResultDecorator preResultDecorator;
    private final ResultDecorator postResultDecorator;
    private final ResultAppender handleAppender;
    private final ResultAppender statusAppender;
    private final Map<String, Boolean> flags;

    public SessionConfig(PrintWriter out, OutputFormat fmt, ResultDecorator preResultDecorator, ResultDecorator postResultDecorator, ResultAppender handleAppender, ResultAppender statusAppender) {
        this(out, fmt, preResultDecorator, postResultDecorator, handleAppender, statusAppender, true, true, true);
    }

    public SessionConfig(PrintWriter out, OutputFormat fmt, boolean optimize, boolean executeQuery, boolean generateJobSpec) {
        this(out, fmt, null, null, null, null, optimize, executeQuery, generateJobSpec);
    }

    public SessionConfig(PrintWriter out, OutputFormat fmt, ResultDecorator preResultDecorator, ResultDecorator postResultDecorator, ResultAppender handleAppender, ResultAppender statusAppender, boolean optimize, boolean executeQuery, boolean generateJobSpec) {
        this.out = out;
        this.fmt = fmt;
        this.preResultDecorator = preResultDecorator;
        this.postResultDecorator = postResultDecorator;
        this.handleAppender = handleAppender;
        this.statusAppender = statusAppender;
        this.optimize = optimize;
        this.executeQuery = executeQuery;
        this.generateJobSpec = generateJobSpec;
        this.flags = new HashMap<String, Boolean>();
    }

    public PrintWriter out() {
        return this.out;
    }

    public OutputFormat fmt() {
        return this.fmt;
    }

    public AlgebricksAppendable resultPrefix(AlgebricksAppendable app) throws AlgebricksException {
        return this.preResultDecorator != null ? this.preResultDecorator.append(app) : app;
    }

    public AlgebricksAppendable resultPostfix(AlgebricksAppendable app) throws AlgebricksException {
        return this.postResultDecorator != null ? this.postResultDecorator.append(app) : app;
    }

    public AlgebricksAppendable appendHandle(AlgebricksAppendable app, String handle) throws AlgebricksException {
        return this.handleAppender != null ? this.handleAppender.append(app, handle) : app;
    }

    public AlgebricksAppendable appendStatus(AlgebricksAppendable app, String status) throws AlgebricksException {
        return this.statusAppender != null ? this.statusAppender.append(app, status) : app;
    }

    public boolean isExecuteQuery() {
        return this.executeQuery;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public boolean isGenerateJobSpec() {
        return this.generateJobSpec;
    }

    public void setOOBData(boolean exprTree, boolean rewrittenExprTree, boolean logicalPlan, boolean optimizedLogicalPlan, boolean hyracksJob) {
        this.set(OOB_EXPR_TREE, exprTree);
        this.set(OOB_REWRITTEN_EXPR_TREE, rewrittenExprTree);
        this.set(OOB_LOGICAL_PLAN, logicalPlan);
        this.set(OOB_OPTIMIZED_LOGICAL_PLAN, optimizedLogicalPlan);
        this.set(OOB_HYRACKS_JOB, hyracksJob);
    }

    public void set(String flag, boolean value) {
        this.flags.put(flag, value);
    }

    public boolean is(String flag) {
        Boolean value = this.flags.get(flag);
        return value == null ? false : value;
    }

    @FunctionalInterface
    public static interface ResultAppender {
        public AlgebricksAppendable append(AlgebricksAppendable var1, String var2) throws AlgebricksException;
    }

    @FunctionalInterface
    public static interface ResultDecorator {
        public AlgebricksAppendable append(AlgebricksAppendable var1) throws AlgebricksException;
    }

    public static enum OutputFormat {
        ADM,
        CSV,
        CLEAN_JSON,
        LOSSLESS_JSON;

    }
}

