/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.DataOutput;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public abstract class AbstractBinaryScalarEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected DataOutput dataOutput = this.resultStorage.getDataOutput();
    protected IPointable[] pointables;
    protected IScalarEvaluator[] evaluators;
    private static final String FIRST = "1st";
    private static final String SECOND = "2nd";
    private static final String THIRD = "3rd";
    private static final String TH = "th";
    private final TypeChecker typeChecker;

    public AbstractBinaryScalarEvaluator$_EvaluatorGen(IHyracksTaskContext context, IScalarEvaluatorFactory[] evaluatorFactories) throws HyracksDataException {
        this.pointables = new IPointable[evaluatorFactories.length];
        this.evaluators = new IScalarEvaluator[evaluatorFactories.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.pointables[i] = new VoidPointable();
            this.evaluators[i] = evaluatorFactories[i].createScalarEvaluator(context);
        }
        this.typeChecker = new TypeChecker();
    }

    protected String rankToString(int i) {
        String prefix = "";
        if (i >= 10) {
            prefix = String.valueOf(i / 10);
        }
        switch (i % 10) {
            case 1: {
                return prefix + FIRST;
            }
            case 2: {
                return prefix + SECOND;
            }
            case 3: {
                return prefix + THIRD;
            }
        }
        return String.valueOf(i) + TH;
    }

    protected void checkTypeMachingThrowsIfNot(String title, ATypeTag[] expected, ATypeTag ... actual) throws HyracksDataException {
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i] || ATypeHierarchy.canPromote((ATypeTag)actual[i], (ATypeTag)expected[i]) || ATypeHierarchy.canPromote((ATypeTag)expected[i], (ATypeTag)actual[i])) continue;
            throw new TypeMismatchException(title, Integer.valueOf(i), actual[i].serialize(), new byte[]{expected[i].serialize()});
        }
    }
}

