/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.StringToCodePointDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class StringToCodePointDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final IPointable argPtr = new VoidPointable();
    protected final IScalarEvaluator stringEval;
    protected final AOrderedListType intListType;
    private OrderedListBuilder listBuilder;
    private ArrayBackedValueStorage inputVal;
    private final ISerializerDeserializer<AInt64> int64Serde;
    private final AMutableInt64 aInt64;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ StringToCodePointDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    StringToCodePointDescriptor$_EvaluatorGen(StringToCodePointDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.stringEval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.intListType = new AOrderedListType((IAType)BuiltinType.AINT64, null);
        this.listBuilder = new OrderedListBuilder();
        this.inputVal = new ArrayBackedValueStorage();
        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
        this.aInt64 = new AMutableInt64(0L);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int offset;
            this.resultStorage.reset();
            this.stringEval.evaluate(tuple, this.argPtr);
            if (this.typeChecker.isMissing(this.argPtr, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.argPtr.getByteArray();
            if (serString[offset = this.argPtr.getStartOffset()] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                int len = UTF8StringUtil.getUTFLength((byte[])serString, (int)(offset + 1));
                int start = offset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)len);
                this.listBuilder.reset((AbstractCollectionType)this.intListType);
                for (int pos = 0; pos < len; pos += UTF8StringUtil.charSize((byte[])serString, (int)(start + pos))) {
                    int codePoint = UTF8StringUtil.UTF8ToCodePoint((byte[])serString, (int)(start + pos));
                    this.inputVal.reset();
                    this.aInt64.setValue((long)codePoint);
                    this.int64Serde.serialize((Object)this.aInt64, this.inputVal.getDataOutput());
                    this.listBuilder.addItem((IValueReference)this.inputVal);
                }
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), serString[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            this.listBuilder.write(this.out, true);
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e1) {
            throw new HyracksDataException((Throwable)e1);
        }
    }
}

