/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.functions.NumericSubtractDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class NumericSubtractDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable argPtr = new VoidPointable();
    private IScalarEvaluator evalLeft;
    private IScalarEvaluator evalRight;
    private double[] operands;
    private boolean metInt8;
    private boolean metInt16;
    private boolean metInt32;
    private boolean metInt64;
    private boolean metFloat;
    private boolean metDouble;
    private ATypeTag typeTag;
    private AMutableDouble aDouble;
    private AMutableFloat aFloat;
    private AMutableInt64 aInt64;
    private AMutableInt32 aInt32;
    private AMutableInt16 aInt16;
    private AMutableInt8 aInt8;
    private ISerializerDeserializer serde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ NumericSubtractDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    NumericSubtractDescriptor$_EvaluatorGen(NumericSubtractDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.evalLeft = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.evalRight = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.operands = new double[this.this$1.val$args.length];
        this.metInt8 = false;
        this.metInt16 = false;
        this.metInt32 = false;
        this.metInt64 = false;
        this.metFloat = false;
        this.metDouble = false;
        this.aDouble = new AMutableDouble(0.0);
        this.aFloat = new AMutableFloat(0.0f);
        this.aInt64 = new AMutableInt64(0L);
        this.aInt32 = new AMutableInt32(0);
        this.aInt16 = new AMutableInt16(0);
        this.aInt8 = new AMutableInt8(0);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        block8: for (int i = 0; i < this.this$1.val$args.length; ++i) {
            if (i == 0) {
                this.evalLeft.evaluate(tuple, this.argPtr);
                if (this.typeChecker.isMissing(this.argPtr, result)) {
                    return;
                }
            } else {
                this.evalRight.evaluate(tuple, this.argPtr);
                if (this.typeChecker.isMissing(this.argPtr, result)) {
                    return;
                }
            }
            byte[] data = this.argPtr.getByteArray();
            int offset = this.argPtr.getStartOffset();
            this.typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(data[offset]);
            switch (this.typeTag) {
                case INT8: {
                    this.metInt8 = true;
                    this.operands[i] = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                case INT16: {
                    this.metInt16 = true;
                    this.operands[i] = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                case INT32: {
                    this.metInt32 = true;
                    this.operands[i] = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                case INT64: {
                    this.metInt64 = true;
                    this.operands[i] = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                case FLOAT: {
                    this.metFloat = true;
                    this.operands[i] = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                case DOUBLE: {
                    this.metDouble = true;
                    this.operands[i] = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
                    continue block8;
                }
                default: {
                    throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(i), data[offset], new byte[]{ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG});
                }
            }
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        if (this.metDouble) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
            this.aDouble.setValue(this.operands[0] - this.operands[1]);
            this.serde.serialize((Object)this.aDouble, this.out);
        } else if (this.metFloat) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
            this.aFloat.setValue((float)(this.operands[0] - this.operands[1]));
            this.serde.serialize((Object)this.aFloat, this.out);
        } else if (this.metInt64) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
            this.aInt64.setValue((long)(this.operands[0] - this.operands[1]));
            this.serde.serialize((Object)this.aInt64, this.out);
        } else if (this.metInt32) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
            this.aInt32.setValue((int)(this.operands[0] - this.operands[1]));
            this.serde.serialize((Object)this.aInt32, this.out);
        } else if (this.metInt16) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
            this.aInt16.setValue((short)(this.operands[0] - this.operands[1]));
            this.serde.serialize((Object)this.aInt16, this.out);
        } else if (this.metInt8) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
            this.aInt8.setValue((byte)(this.operands[0] - this.operands[1]));
            this.serde.serialize((Object)this.aInt8, this.out);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

