/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CreatePolygonDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class CreatePolygonDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ListAccessor listAccessor = new ListAccessor();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IScalarEvaluatorFactory listEvalFactory;
    private final IPointable inputArgList;
    private final IScalarEvaluator evalList;
    private final ISerializerDeserializer<ANull> nullSerde;
    private final ISerializerDeserializer<AMissing> missingSerde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ CreatePolygonDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    CreatePolygonDescriptor$_EvaluatorGen(CreatePolygonDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.listEvalFactory = this.this$1.val$args[0];
        this.inputArgList = new VoidPointable();
        this.evalList = this.listEvalFactory.createScalarEvaluator(this.val$ctx);
        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
        this.missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int offset;
            this.resultStorage.reset();
            this.evalList.evaluate(tuple, this.inputArgList);
            if (this.typeChecker.isMissing(this.inputArgList, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] listBytes = this.inputArgList.getByteArray();
            if (listBytes[offset = this.inputArgList.getStartOffset()] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && listBytes[offset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), listBytes[offset], new byte[]{ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG});
            }
            this.listAccessor.reset(listBytes, offset);
            try {
                for (int i = 0; i < this.listAccessor.size(); ++i) {
                    int itemOffset = this.listAccessor.getItemOffset(i);
                    ATypeTag itemType = this.listAccessor.getItemType(itemOffset);
                    if (itemType == ATypeTag.DOUBLE) continue;
                    if (itemType == ATypeTag.NULL) {
                        this.nullSerde.serialize((Object)ANull.NULL, this.out);
                        return;
                    }
                    if (itemType == ATypeTag.MISSING) {
                        this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
                        return;
                    }
                    throw new UnsupportedItemTypeException(BuiltinFunctions.CREATE_POLYGON, itemType.serialize());
                }
                if (this.listAccessor.size() < 6) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                }
                if (this.listAccessor.size() % 2 != 0) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                }
                this.out.writeByte(ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                this.out.writeShort(this.listAccessor.size() / 2);
                int skipTypeTag = this.listAccessor.itemsAreSelfDescribing() ? 1 : 0;
                for (int i = 0; i < this.listAccessor.size() / 2; ++i) {
                    int firstDoubleOffset = this.listAccessor.getItemOffset(i * 2) + skipTypeTag;
                    int secondDobuleOffset = this.listAccessor.getItemOffset(i * 2 + 1) + skipTypeTag;
                    APointSerializerDeserializer.serialize((double)ADoubleSerializerDeserializer.getDouble((byte[])listBytes, (int)firstDoubleOffset), (double)ADoubleSerializerDeserializer.getDouble((byte[])listBytes, (int)secondDobuleOffset), (DataOutput)this.out);
                }
                result.set((IValueReference)this.resultStorage);
            }
            catch (AsterixException ex) {
                throw new HyracksDataException((Throwable)ex);
            }
        }
        catch (IOException e1) {
            throw new HyracksDataException((Throwable)e1);
        }
    }
}

