/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableUUID;
import org.apache.asterix.om.base.AUUID;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.AUUIDFromStringConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class AUUIDFromStringConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableUUID uuid;
    private ISerializerDeserializer<AUUID> uuidSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ AUUIDFromStringConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    AUUIDFromStringConstructorDescriptor$_EvaluatorGen(AUUIDFromStringConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.uuid = new AMutableUUID();
        this.uuidSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AUUID);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            int start = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (serString[start] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), serString[start], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            this.utf8Ptr.set(serString, start + 1, len - 1);
            int offset = this.utf8Ptr.getCharStartOffset();
            this.uuid.parseUUIDHexBytes(serString, offset);
            this.uuidSerde.serialize((Object)this.uuid, this.out);
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_UUID_TYPE_TAG);
        }
    }
}

