/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.AIntervalStartFromTimeConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class AIntervalStartFromTimeConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable argPtr0 = new VoidPointable();
    private IPointable argPtr1 = new VoidPointable();
    private IScalarEvaluator eval0;
    private IScalarEvaluator eval1;
    private AMutableInterval aInterval;
    private AMutableDuration aDuration;
    private ISerializerDeserializer<AInterval> intervalSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ AIntervalStartFromTimeConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    AIntervalStartFromTimeConstructorDescriptor$_EvaluatorGen(AIntervalStartFromTimeConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.eval1 = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.aInterval = new AMutableInterval(0L, 0L, 0);
        this.aDuration = new AMutableDuration(0, 0L);
        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.argPtr0);
        if (this.typeChecker.isMissing(this.argPtr0, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.argPtr1);
        if (this.typeChecker.isMissing(this.argPtr1, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes0 = this.argPtr0.getByteArray();
        int offset0 = this.argPtr0.getStartOffset();
        int len0 = this.argPtr0.getLength();
        byte[] bytes1 = this.argPtr1.getByteArray();
        int offset1 = this.argPtr1.getStartOffset();
        int len1 = this.argPtr1.getLength();
        try {
            int stringLength;
            long intervalStart = 0L;
            long intervalEnd = 0L;
            if (bytes0[offset0] == ATypeTag.SERIALIZED_TIME_TYPE_TAG) {
                intervalStart = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
            } else if (bytes0[offset0] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                this.utf8Ptr.set(bytes0, offset0 + 1, len0 - 1);
                stringLength = this.utf8Ptr.getUTF8Length();
                intervalStart = ATimeParserFactory.parseTimePart((byte[])bytes0, (int)this.utf8Ptr.getCharStartOffset(), (int)stringLength);
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), bytes0[offset0], new byte[]{ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            if (intervalStart < 0L) {
                intervalStart += 86400000L;
            }
            if (bytes1[offset1] == ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                if (ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1)) != 0) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                }
                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)0, (long)ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1)), (boolean)false);
            } else if (bytes1[offset1] == ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG) {
                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)0, (long)ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1)), (boolean)false);
            } else if (bytes1[offset1] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
                stringLength = this.utf8Ptr.getUTF8Length();
                ADurationParserFactory.parseDuration((Object)bytes1, (int)this.utf8Ptr.getCharStartOffset(), (int)stringLength, (IAObject)this.aDuration, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
                if (this.aDuration.getMonths() != 0) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                }
                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)0, (long)this.aDuration.getMilliseconds(), (boolean)false);
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(1), bytes1[offset1], new byte[]{ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            if (intervalEnd > 86400000L) {
                intervalEnd %= 86400000L;
            }
            if (intervalEnd < intervalStart) {
                throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
            }
            this.aInterval.setValue(intervalStart, intervalEnd, ATypeTag.SERIALIZED_TIME_TYPE_TAG);
            this.intervalSerde.serialize((Object)this.aInterval, this.out);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

