/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AIntervalConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class AIntervalConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable argPtr0 = new VoidPointable();
    private IPointable argPtr1 = new VoidPointable();
    private IScalarEvaluator eval0;
    private IScalarEvaluator eval1;
    private AMutableInterval aInterval;
    private ISerializerDeserializer<AInterval> intervalSerde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ AIntervalConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    AIntervalConstructorDescriptor$_EvaluatorGen(AIntervalConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.eval1 = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.aInterval = new AMutableInterval(0L, 0L, 0);
        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.argPtr0);
        if (this.typeChecker.isMissing(this.argPtr0, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.argPtr1);
        if (this.typeChecker.isMissing(this.argPtr1, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes0 = this.argPtr0.getByteArray();
        int offset0 = this.argPtr0.getStartOffset();
        byte[] bytes1 = this.argPtr1.getByteArray();
        int offset1 = this.argPtr1.getStartOffset();
        try {
            long intervalEnd;
            long intervalStart;
            if (bytes0[offset0] != bytes1[offset1]) {
                throw new IncompatibleTypeException(this.this$1.this$0.getIdentifier(), bytes0[offset0], bytes1[offset1]);
            }
            ATypeTag intervalType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
            switch (intervalType) {
                case DATE: {
                    intervalStart = ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                    intervalEnd = ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                    break;
                }
                case TIME: {
                    intervalStart = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                    intervalEnd = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                    break;
                }
                case DATETIME: {
                    intervalStart = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                    intervalEnd = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                    break;
                }
                default: {
                    throw new UnsupportedItemTypeException(this.this$1.this$0.getIdentifier(), bytes0[offset0]);
                }
            }
            if (intervalEnd < intervalStart) {
                throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
            }
            this.aInterval.setValue(intervalStart, intervalEnd, intervalType.serialize());
            this.intervalSerde.serialize((Object)this.aInterval, this.out);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

