/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.ADoubleConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class ADoubleConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private final byte[] POSITIVE_INF;
    private final byte[] NEGATIVE_INF;
    private final byte[] NAN;
    IBinaryComparator utf8BinaryComparator;
    private AMutableDouble aDouble;
    private ISerializerDeserializer<ADouble> doubleSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ADoubleConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ADoubleConstructorDescriptor$_EvaluatorGen(ADoubleConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.POSITIVE_INF = UTF8StringUtil.writeStringToBytes((String)"INF");
        this.NEGATIVE_INF = UTF8StringUtil.writeStringToBytes((String)"-INF");
        this.NAN = UTF8StringUtil.writeStringToBytes((String)"NaN");
        this.utf8BinaryComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
        this.aDouble = new AMutableDouble(0.0);
        this.doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (serString[offset] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.POSITIVE_INF, 0, 5) == 0) {
                    this.aDouble.setValue(Double.POSITIVE_INFINITY);
                } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NEGATIVE_INF, 0, 6) == 0) {
                    this.aDouble.setValue(Double.NEGATIVE_INFINITY);
                } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NAN, 0, 5) == 0) {
                    this.aDouble.setValue(Double.NaN);
                } else {
                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                    this.aDouble.setValue(Double.parseDouble(this.utf8Ptr.toString()));
                }
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), serString[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            this.doubleSerde.serialize((Object)this.aDouble, this.out);
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
        }
    }
}

