/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.ABooleanConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class ABooleanConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private final byte[] TRUE;
    private final byte[] FALSE;
    IBinaryComparator utf8BinaryComparator;
    private ISerializerDeserializer<ABoolean> booleanSerde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ABooleanConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ABooleanConstructorDescriptor$_EvaluatorGen(ABooleanConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.TRUE = UTF8StringUtil.writeStringToBytes((String)"true");
        this.FALSE = UTF8StringUtil.writeStringToBytes((String)"false");
        this.utf8BinaryComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
        this.booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            int startOffset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (serString[startOffset] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                if (this.utf8BinaryComparator.compare(serString, startOffset + 1, len - 1, this.TRUE, 0, this.TRUE.length) == 0) {
                    this.booleanSerde.serialize((Object)ABoolean.TRUE, this.out);
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                if (this.utf8BinaryComparator.compare(serString, startOffset + 1, len - 1, this.FALSE, 0, this.FALSE.length) == 0) {
                    this.booleanSerde.serialize((Object)ABoolean.FALSE, this.out);
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
            }
            throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), serString[startOffset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
        }
    }
}

