/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.optimizer.rules.subplan.InlineAllNtsInSubplanVisitor;
import org.apache.asterix.optimizer.rules.subplan.InlineLeftNtsInSubplanJoinFlatteningVisitor;
import org.apache.asterix.optimizer.rules.subplan.SubplanSpecialFlatteningCheckVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

class SubplanFlatteningUtil {
    SubplanFlatteningUtil() {
    }

    public static Pair<Map<LogicalVariable, LogicalVariable>, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>> inlineAllNestedTupleSource(SubplanOperator subplanOp, IOptimizationContext context) throws AlgebricksException {
        if (OperatorManipulationUtil.ancestorOfOperators((ILogicalOperator)subplanOp, (Set)ImmutableSet.of((Object)LogicalOperatorTag.NESTEDTUPLESOURCE))) {
            return new Pair(null, null);
        }
        InlineAllNtsInSubplanVisitor visitor = new InlineAllNtsInSubplanVisitor(context, (ILogicalOperator)subplanOp);
        ILogicalOperator topOp = (ILogicalOperator)SubplanFlatteningUtil.findLowestAggregate((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0))).getValue();
        ILogicalOperator opToVisit = (ILogicalOperator)((Mutable)topOp.getInputs().get(0)).getValue();
        ILogicalOperator result = (ILogicalOperator)opToVisit.accept((ILogicalOperatorVisitor)visitor, null);
        ((Mutable)topOp.getInputs().get(0)).setValue((Object)result);
        VariableUtilities.substituteVariables((ILogicalOperator)topOp, visitor.getVariableMapHistory(), (ITypingContext)context);
        List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderVars = visitor.getOrderingExpressions();
        return new Pair(visitor.getInputVariableToOutputVariableMap(), orderVars);
    }

    public static Pair<Set<LogicalVariable>, Mutable<ILogicalOperator>> inlineLeftNtsInSubplanJoin(SubplanOperator subplanOp, IOptimizationContext context) throws AlgebricksException {
        Pair<Boolean, ILogicalOperator> applicableAndNtsToRewrite = SubplanFlatteningUtil.isQualifiedForSpecialFlattening(subplanOp);
        if (!((Boolean)applicableAndNtsToRewrite.first).booleanValue()) {
            return new Pair(null, null);
        }
        ILogicalOperator qualifiedNts = (ILogicalOperator)applicableAndNtsToRewrite.second;
        ILogicalOperator subplanInputOp = (ILogicalOperator)((Mutable)subplanOp.getInputs().get(0)).getValue();
        InlineLeftNtsInSubplanJoinFlatteningVisitor specialVisitor = new InlineLeftNtsInSubplanJoinFlatteningVisitor(context, subplanInputOp, qualifiedNts);
        Mutable topRef = (Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0);
        ILogicalOperator result = (ILogicalOperator)((ILogicalOperator)topRef.getValue()).accept((ILogicalOperatorVisitor)specialVisitor, null);
        Mutable<ILogicalOperator> topJoinRef = specialVisitor.getTopJoinReference();
        topRef.setValue((Object)result);
        InlineAllNtsInSubplanVisitor generalVisitor = new InlineAllNtsInSubplanVisitor(context, (ILogicalOperator)subplanOp);
        ILogicalOperator opToVisit = (ILogicalOperator)topJoinRef.getValue();
        result = (ILogicalOperator)opToVisit.accept((ILogicalOperatorVisitor)generalVisitor, null);
        topJoinRef.setValue((Object)result);
        List<Pair<LogicalVariable, LogicalVariable>> subplanLocalVarMap = generalVisitor.getVariableMapHistory();
        ILogicalOperator currentOp = (ILogicalOperator)topRef.getValue();
        while (currentOp != result) {
            VariableUtilities.substituteVariables((ILogicalOperator)currentOp, subplanLocalVarMap, (ITypingContext)context);
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return new Pair(specialVisitor.getNullCheckVariables(), topJoinRef);
    }

    public static boolean containsOperators(SubplanOperator subplanOp, Set<LogicalOperatorTag> interestedOperatorTags) {
        List nestedPlans = subplanOp.getNestedPlans();
        for (ILogicalPlan nestedPlan : nestedPlans) {
            for (Mutable opRef : nestedPlan.getRoots()) {
                if (!SubplanFlatteningUtil.containsOperatorsInternal((ILogicalOperator)opRef.getValue(), interestedOperatorTags)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOperatorsInternal(ILogicalOperator currentOp, Set<LogicalOperatorTag> interestedOperatorTags) {
        if (interestedOperatorTags.contains(currentOp.getOperatorTag())) {
            return true;
        }
        if (currentOp.getOperatorTag() == LogicalOperatorTag.SUBPLAN && SubplanFlatteningUtil.containsOperators((SubplanOperator)currentOp, interestedOperatorTags)) {
            return true;
        }
        for (Mutable childRef : currentOp.getInputs()) {
            if (!SubplanFlatteningUtil.containsOperatorsInternal((ILogicalOperator)childRef.getValue(), interestedOperatorTags)) continue;
            return true;
        }
        return false;
    }

    public static Mutable<ILogicalOperator> findLowestAggregate(Mutable<ILogicalOperator> currentOpRef) {
        ILogicalOperator currentOp = (ILogicalOperator)currentOpRef.getValue();
        if (currentOp.getInputs().size() != 1 || currentOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            return null;
        }
        Mutable<ILogicalOperator> childReturn = SubplanFlatteningUtil.findLowestAggregate((Mutable<ILogicalOperator>)((Mutable)currentOp.getInputs().get(0)));
        if (childReturn == null) {
            return currentOp.getOperatorTag() == LogicalOperatorTag.AGGREGATE ? currentOpRef : null;
        }
        return childReturn;
    }

    private static Pair<Boolean, ILogicalOperator> isQualifiedForSpecialFlattening(SubplanOperator subplanOp) throws AlgebricksException {
        if (!OperatorManipulationUtil.ancestorOfOperators((ILogicalOperator)((ILogicalOperator)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)).getValue()), (Set)ImmutableSet.of((Object)LogicalOperatorTag.INNERJOIN, (Object)LogicalOperatorTag.LEFTOUTERJOIN))) {
            return new Pair((Object)false, null);
        }
        SubplanSpecialFlatteningCheckVisitor visitor = new SubplanSpecialFlatteningCheckVisitor();
        for (ILogicalPlan plan : subplanOp.getNestedPlans()) {
            for (Mutable opRef : plan.getRoots()) {
                if (((Boolean)((ILogicalOperator)opRef.getValue()).accept((ILogicalOperatorVisitor)visitor, null)).booleanValue()) continue;
                return new Pair((Object)false, null);
            }
        }
        return new Pair((Object)true, (Object)visitor.getQualifiedNts());
    }
}

