/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.asterix.algebra.operators.physical.ExternalDataLookupPOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;

public class AccessMethodUtils {
    public static void appendPrimaryIndexTypes(Dataset dataset, IAType itemType, IAType metaItemType, List<Object> target) throws AlgebricksException {
        ARecordType recordType = (ARecordType)itemType;
        ARecordType metaRecordType = (ARecordType)metaItemType;
        target.addAll(KeyFieldTypeUtil.getPartitoningKeyTypes((Dataset)dataset, (ARecordType)recordType, (ARecordType)metaRecordType));
        target.add(itemType);
        if (dataset.hasMetaPart()) {
            target.add(metaItemType);
        }
    }

    public static ConstantExpression createStringConstant(String str) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(str)));
    }

    public static ConstantExpression createInt32Constant(int i) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)));
    }

    public static ConstantExpression createBooleanConstant(boolean b) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.valueOf((boolean)b)));
    }

    public static String getStringConstant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static int getInt32Constant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getIntConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static long getInt64Constant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getLongConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static boolean getBooleanConstant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getBooleanConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static boolean analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        ILogicalExpression constExpression = null;
        IAType constantExpressionType = null;
        LogicalVariable fieldVar = null;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE && arg2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (arg2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.STRING_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                return false;
            }
            IAType expressionType = AccessMethodUtils.constantRuntimeResultType(arg1, context, typeEnvironment);
            if (expressionType == null) {
                return false;
            }
            constantExpressionType = expressionType;
            constExpression = arg1;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)arg2;
            fieldVar = varExpr.getVariableReference();
        } else if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType expressionType = AccessMethodUtils.constantRuntimeResultType(arg2, context, typeEnvironment);
            if (expressionType == null) {
                return false;
            }
            constantExpressionType = expressionType;
            constExpression = arg2;
            if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS && arg2.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                AccessMethodUtils.checkFTSearchConstantExpression(constExpression);
            }
            VariableReferenceExpression varExpr = (VariableReferenceExpression)arg1;
            fieldVar = varExpr.getVariableReference();
        } else {
            return false;
        }
        AccessMethodUtils.constructNewOptFuncExprAndAddToAnalysisCtx(funcExpr, fieldVar, constExpression, constantExpressionType, analysisCtx);
        return true;
    }

    private static void constructNewOptFuncExprAndAddToAnalysisCtx(AbstractFunctionCallExpression funcExpr, LogicalVariable fieldVar, ILogicalExpression expression, IAType expressionType, AccessMethodAnalysisContext analysisCtx) {
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, fieldVar, expression, expressionType);
        AccessMethodUtils.addNewOptFuncExprToAnalysisCtx(funcExpr, newOptFuncExpr, analysisCtx);
    }

    private static void constructNewOptFuncExprAndAddToAnalysisCtx(AbstractFunctionCallExpression funcExpr, LogicalVariable[] fieldVars, ILogicalExpression[] expressions, IAType[] expressionTypes, AccessMethodAnalysisContext analysisCtx) {
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, fieldVars, expressions, expressionTypes);
        AccessMethodUtils.addNewOptFuncExprToAnalysisCtx(funcExpr, newOptFuncExpr, analysisCtx);
    }

    private static void addNewOptFuncExprToAnalysisCtx(AbstractFunctionCallExpression funcExpr, OptimizableFuncExpr newOptFuncExpr, AccessMethodAnalysisContext analysisCtx) {
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            if (!optFuncExpr.getFuncExpr().equals((Object)funcExpr)) continue;
            return;
        }
        analysisCtx.addMatchedFuncExpr(newOptFuncExpr);
    }

    private static void checkEachElementInFTSearchListPredicate(IACursor oListCursor) throws AlgebricksException {
        while (oListCursor.next()) {
            IAObject element = oListCursor.get();
            if (element.getType() == BuiltinType.ASTRING) {
                String argValue = ConstantExpressionUtil.getStringConstant((IAObject)element);
                AccessMethodUtils.checkAndGenerateFTSearchExceptionForStringPhrase(argValue);
                continue;
            }
            throw new CompilationException(1004, new Serializable[]{BuiltinFunctions.FULLTEXT_CONTAINS.getName(), element.getType().getTypeTag()});
        }
    }

    public static void checkFTSearchConstantExpression(ILogicalExpression constExpression) throws AlgebricksException {
        IAObject objectFromExpr = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)constExpression, null);
        switch (objectFromExpr.getType().getTypeTag()) {
            case STRING: {
                String arg2Value = ConstantExpressionUtil.getStringConstant((IAObject)objectFromExpr);
                AccessMethodUtils.checkAndGenerateFTSearchExceptionForStringPhrase(arg2Value);
                break;
            }
            case ORDEREDLIST: {
                IACursor oListCursor = ConstantExpressionUtil.getOrderedListConstant((IAObject)objectFromExpr).getCursor();
                AccessMethodUtils.checkEachElementInFTSearchListPredicate(oListCursor);
                break;
            }
            case UNORDEREDLIST: {
                IACursor oListCursor = ConstantExpressionUtil.getUnorderedListConstant((IAObject)objectFromExpr).getCursor();
                AccessMethodUtils.checkEachElementInFTSearchListPredicate(oListCursor);
                break;
            }
            default: {
                throw new CompilationException(1004, new Serializable[]{BuiltinFunctions.FULLTEXT_CONTAINS.getName(), objectFromExpr.getType().getTypeTag()});
            }
        }
    }

    public static void checkAndGenerateFTSearchExceptionForStringPhrase(String value) throws AlgebricksException {
        for (int j = 0; j < value.length(); ++j) {
            if (!DelimitedUTF8StringBinaryTokenizer.isSeparator((char)value.charAt(j))) continue;
            throw new CompilationException(1010, new Serializable[0]);
        }
    }

    public static boolean analyzeFuncExprArgsForTwoVarsAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, AccessMethodAnalysisContext analysisCtx) {
        LogicalVariable fieldVar1 = null;
        LogicalVariable fieldVar2 = null;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.VARIABLE || arg2.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        fieldVar1 = ((VariableReferenceExpression)arg1).getVariableReference();
        fieldVar2 = ((VariableReferenceExpression)arg2).getVariableReference();
        AccessMethodUtils.constructNewOptFuncExprAndAddToAnalysisCtx(funcExpr, new LogicalVariable[]{fieldVar1, fieldVar2}, new ILogicalExpression[0], new IAType[0], analysisCtx);
        return true;
    }

    public static void appendSecondaryIndexTypes(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, boolean primaryKeysOnly, List<Object> dest) throws AlgebricksException {
        if (!primaryKeysOnly) {
            switch (index.getIndexType()) {
                case BTREE: {
                    dest.addAll(KeyFieldTypeUtil.getBTreeIndexKeyTypes((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType));
                    break;
                }
                case RTREE: {
                    dest.addAll(KeyFieldTypeUtil.getRTreeIndexKeyTypes((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType));
                    break;
                }
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            try {
                AccessMethodUtils.appendExternalRecPrimaryKeys(dataset, dest);
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
        } else {
            dest.addAll(KeyFieldTypeUtil.getPartitoningKeyTypes((Dataset)dataset, (ARecordType)recordType, (ARecordType)metaRecordType));
        }
    }

    public static void appendSecondaryIndexOutputVars(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, boolean primaryKeysOnly, IOptimizationContext context, List<LogicalVariable> dest) throws AlgebricksException {
        int numPrimaryKeys = 0;
        numPrimaryKeys = dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties()) : DatasetUtil.getPartitioningKeys((Dataset)dataset).size();
        int numSecondaryKeys = KeyFieldTypeUtil.getNumSecondaryKeys((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType);
        int numVars = primaryKeysOnly ? numPrimaryKeys : numPrimaryKeys + numSecondaryKeys;
        for (int i = 0; i < numVars; ++i) {
            dest.add(context.newVar());
        }
    }

    public static List<LogicalVariable> getPrimaryKeyVarsFromSecondaryUnnestMap(Dataset dataset, ILogicalOperator unnestMapOp) {
        int numPrimaryKeys = dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties()) : DatasetUtil.getPartitioningKeys((Dataset)dataset).size();
        ArrayList<LogicalVariable> primaryKeyVars = new ArrayList<LogicalVariable>();
        List sourceVars = null;
        sourceVars = ((AbstractUnnestMapOperator)unnestMapOp).getVariables();
        int start = sourceVars.size() - numPrimaryKeys;
        int stop = sourceVars.size();
        for (int i = start; i < stop; ++i) {
            primaryKeyVars.add((LogicalVariable)sourceVars.get(i));
        }
        return primaryKeyVars;
    }

    public static List<LogicalVariable> getPrimaryKeyVarsFromPrimaryUnnestMap(Dataset dataset, ILogicalOperator unnestMapOp) {
        int numPrimaryKeys = DatasetUtil.getPartitioningKeys((Dataset)dataset).size();
        ArrayList<LogicalVariable> primaryKeyVars = new ArrayList<LogicalVariable>();
        List sourceVars = null;
        sourceVars = ((AbstractUnnestMapOperator)unnestMapOp).getVariables();
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyVars.add((LogicalVariable)sourceVars.get(i));
        }
        return primaryKeyVars;
    }

    public static Pair<ILogicalExpression, Boolean> createSearchKeyExpr(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree) throws AlgebricksException {
        if (probeSubTree == null) {
            IAType fieldType = optFuncExpr.getFieldType(0);
            if (optFuncExpr.getNumConstantExpr() == 0) {
                return new Pair((Object)new VariableReferenceExpression(optFuncExpr.getLogicalVar(1)), (Object)false);
            }
            ILogicalExpression constantAtRuntimeExpression = null;
            AsterixConstantValue constantValue = null;
            ATypeTag constantValueTag = null;
            constantAtRuntimeExpression = optFuncExpr.getConstantExpr(0);
            if (constantAtRuntimeExpression.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                constantValue = (AsterixConstantValue)((ConstantExpression)constantAtRuntimeExpression).getValue();
            }
            constantValueTag = optFuncExpr.getConstantType(0).getTypeTag();
            boolean typeCastingApplied = false;
            boolean realTypeConvertedToIntegerType = false;
            AsterixConstantValue replacedConstantValue = null;
            if (constantValueTag != fieldType.getTypeTag() && constantValue != null) {
                replacedConstantValue = ATypeHierarchy.getAsterixConstantValueFromNumericTypeObject((IAObject)constantValue.getObject(), (ATypeTag)fieldType.getTypeTag());
                if (replacedConstantValue != null) {
                    typeCastingApplied = true;
                }
                block0 : switch (constantValueTag) {
                    case DOUBLE: 
                    case FLOAT: {
                        switch (fieldType.getTypeTag()) {
                            case INT8: 
                            case INT16: 
                            case INT32: 
                            case INT64: {
                                realTypeConvertedToIntegerType = true;
                                break block0;
                            }
                        }
                    }
                }
            }
            if (typeCastingApplied) {
                return new Pair((Object)new ConstantExpression((IAlgebricksConstantValue)replacedConstantValue), (Object)realTypeConvertedToIntegerType);
            }
            return new Pair((Object)optFuncExpr.getConstantExpr(0), (Object)false);
        }
        if (optFuncExpr.getOperatorSubTree(0) == null || optFuncExpr.getOperatorSubTree(0) == probeSubTree) {
            return new Pair((Object)new VariableReferenceExpression(optFuncExpr.getLogicalVar(0)), (Object)false);
        }
        return new Pair((Object)new VariableReferenceExpression(optFuncExpr.getLogicalVar(1)), (Object)false);
    }

    public static IOptimizableFuncExpr chooseFirstOptFuncExpr(Index chosenIndex, AccessMethodAnalysisContext analysisCtx) {
        List<Pair<Integer, Integer>> indexExprs = analysisCtx.getIndexExprsFromIndexExprsAndVars(chosenIndex);
        int firstExprIndex = (Integer)indexExprs.get((int)0).first;
        return analysisCtx.getMatchedFuncExpr(firstExprIndex);
    }

    public static int chooseFirstOptFuncVar(Index chosenIndex, AccessMethodAnalysisContext analysisCtx) {
        List<Pair<Integer, Integer>> indexExprs = analysisCtx.getIndexExprsFromIndexExprsAndVars(chosenIndex);
        return (Integer)indexExprs.get((int)0).second;
    }

    public static ILogicalOperator createSecondaryIndexUnnestMap(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, ILogicalOperator inputOp, AccessMethodJobGenParams jobGenParams, IOptimizationContext context, boolean outputPrimaryKeysOnly, boolean retainInput, boolean retainNull) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> secondaryIndexFuncArgs = new ArrayList<Mutable<ILogicalExpression>>();
        jobGenParams.writeToFuncArgs(secondaryIndexFuncArgs);
        ArrayList<LogicalVariable> secondaryIndexUnnestVars = new ArrayList<LogicalVariable>();
        ArrayList<Object> secondaryIndexOutputTypes = new ArrayList<Object>();
        AccessMethodUtils.appendSecondaryIndexOutputVars(dataset, recordType, metaRecordType, index, outputPrimaryKeysOnly, context, secondaryIndexUnnestVars);
        AccessMethodUtils.appendSecondaryIndexTypes(dataset, recordType, metaRecordType, index, outputPrimaryKeysOnly, secondaryIndexOutputTypes);
        IFunctionInfo secondaryIndexSearch = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.INDEX_SEARCH);
        UnnestingFunctionCallExpression secondaryIndexSearchFunc = new UnnestingFunctionCallExpression(secondaryIndexSearch, secondaryIndexFuncArgs);
        secondaryIndexSearchFunc.setReturnsUniqueValues(true);
        if (retainNull) {
            if (retainInput) {
                LeftOuterUnnestMapOperator secondaryIndexLeftOuterUnnestOp = new LeftOuterUnnestMapOperator(secondaryIndexUnnestVars, (Mutable)new MutableObject((Object)secondaryIndexSearchFunc), secondaryIndexOutputTypes, true);
                secondaryIndexLeftOuterUnnestOp.getInputs().add(new MutableObject((Object)inputOp));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)secondaryIndexLeftOuterUnnestOp);
                secondaryIndexLeftOuterUnnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                return secondaryIndexLeftOuterUnnestOp;
            }
            throw new AlgebricksException("Left-outer-join should propagate all inputs from the outer branch.");
        }
        UnnestMapOperator secondaryIndexUnnestOp = new UnnestMapOperator(secondaryIndexUnnestVars, (Mutable)new MutableObject((Object)secondaryIndexSearchFunc), secondaryIndexOutputTypes, retainInput);
        secondaryIndexUnnestOp.getInputs().add(new MutableObject((Object)inputOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)secondaryIndexUnnestOp);
        secondaryIndexUnnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        return secondaryIndexUnnestOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractUnnestMapOperator createPrimaryIndexUnnestMap(AbstractDataSourceOperator dataSourceOp, Dataset dataset, ARecordType recordType, ARecordType metaRecordType, ILogicalOperator inputOp, IOptimizationContext context, boolean sortPrimaryKeys, boolean retainInput, boolean retainNull, boolean requiresBroadcast) throws AlgebricksException {
        List<LogicalVariable> primaryKeyVars = AccessMethodUtils.getPrimaryKeyVarsFromSecondaryUnnestMap(dataset, inputOp);
        OrderOperator order = null;
        if (sortPrimaryKeys) {
            order = new OrderOperator();
            for (LogicalVariable pkVar : primaryKeyVars) {
                MutableObject vRef = new MutableObject((Object)new VariableReferenceExpression(pkVar));
                order.getOrderExpressions().add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)vRef));
            }
            order.getInputs().add(new MutableObject((Object)inputOp));
            order.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)order);
        }
        ArrayList<Mutable<ILogicalExpression>> primaryIndexFuncArgs = new ArrayList<Mutable<ILogicalExpression>>();
        BTreeJobGenParams jobGenParams = new BTreeJobGenParams(dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, requiresBroadcast);
        jobGenParams.setLowKeyInclusive(true);
        jobGenParams.setHighKeyInclusive(true);
        jobGenParams.setLowKeyVarList(primaryKeyVars, 0, primaryKeyVars.size());
        jobGenParams.setHighKeyVarList(primaryKeyVars, 0, primaryKeyVars.size());
        jobGenParams.setIsEqCondition(true);
        jobGenParams.writeToFuncArgs(primaryIndexFuncArgs);
        ArrayList primaryIndexUnnestVars = new ArrayList();
        ArrayList<Object> primaryIndexOutputTypes = new ArrayList<Object>();
        primaryIndexUnnestVars.addAll(dataSourceOp.getVariables());
        AccessMethodUtils.appendPrimaryIndexTypes(dataset, (IAType)recordType, (IAType)metaRecordType, primaryIndexOutputTypes);
        IFunctionInfo primaryIndexSearch = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.INDEX_SEARCH);
        ScalarFunctionCallExpression primaryIndexSearchFunc = new ScalarFunctionCallExpression(primaryIndexSearch, primaryIndexFuncArgs);
        UnnestMapOperator primaryIndexUnnestOp = null;
        if (retainNull) {
            if (!retainInput) throw new AlgebricksException("Left-outer-join should propagate all inputs from the outer branch.");
            primaryIndexUnnestOp = new LeftOuterUnnestMapOperator(primaryIndexUnnestVars, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, retainInput);
        } else {
            primaryIndexUnnestOp = new UnnestMapOperator(primaryIndexUnnestVars, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, retainInput);
        }
        if (sortPrimaryKeys) {
            primaryIndexUnnestOp.getInputs().add(new MutableObject((Object)order));
        } else {
            primaryIndexUnnestOp.getInputs().add(new MutableObject((Object)inputOp));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)primaryIndexUnnestOp);
        primaryIndexUnnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        return primaryIndexUnnestOp;
    }

    public static ScalarFunctionCallExpression findLOJIsMissingFuncInGroupBy(GroupByOperator lojGroupbyOp) throws AlgebricksException {
        ALogicalPlanImpl subPlan = (ALogicalPlanImpl)lojGroupbyOp.getNestedPlans().get(0);
        Mutable subPlanRootOpRef = (Mutable)subPlan.getRoots().get(0);
        AbstractLogicalOperator subPlanRootOp = (AbstractLogicalOperator)subPlanRootOpRef.getValue();
        boolean foundSelectNonNull = false;
        ScalarFunctionCallExpression isNullFuncExpr = null;
        AbstractLogicalOperator inputOp = subPlanRootOp;
        while (inputOp != null) {
            ScalarFunctionCallExpression notFuncExpr;
            SelectOperator selectOp;
            if (inputOp.getOperatorTag() == LogicalOperatorTag.SELECT && ((ILogicalExpression)(selectOp = (SelectOperator)inputOp).getCondition().getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((AbstractFunctionCallExpression)selectOp.getCondition().getValue()).getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT) && ((ILogicalExpression)((Mutable)(notFuncExpr = (ScalarFunctionCallExpression)selectOp.getCondition().getValue()).getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((AbstractFunctionCallExpression)((Mutable)notFuncExpr.getArguments().get(0)).getValue()).getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.IS_MISSING) && ((ILogicalExpression)((Mutable)(isNullFuncExpr = (ScalarFunctionCallExpression)((Mutable)notFuncExpr.getArguments().get(0)).getValue()).getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                foundSelectNonNull = true;
                break;
            }
            inputOp = inputOp.getInputs().size() > 0 ? (AbstractLogicalOperator)((Mutable)inputOp.getInputs().get(0)).getValue() : null;
        }
        if (!foundSelectNonNull) {
            throw new AlgebricksException("Could not find the non-null select operator in GroupByOperator for LEFTOUTERJOIN plan optimization.");
        }
        return isNullFuncExpr;
    }

    public static void resetLOJNullPlaceholderVariableInGroupByOp(AccessMethodAnalysisContext analysisCtx, LogicalVariable newNullPlaceholderVaraible, IOptimizationContext context) throws AlgebricksException {
        ScalarFunctionCallExpression isNullFuncExpr = analysisCtx.getLOJIsNullFuncInGroupBy();
        isNullFuncExpr.getArguments().clear();
        isNullFuncExpr.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(newNullPlaceholderVaraible)));
        OperatorPropertiesUtil.typeOpRec(analysisCtx.getLOJGroupbyOpRef(), (IOptimizationContext)context);
    }

    private static void appendExternalRecTypes(Dataset dataset, IAType itemType, List<Object> target) {
        target.add(itemType);
    }

    private static void appendExternalRecPrimaryKeys(Dataset dataset, List<Object> target) throws AsterixException {
        int numPrimaryKeys = IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties());
        for (int i = 0; i < numPrimaryKeys; ++i) {
            target.add(IndexingConstants.getFieldType((int)i));
        }
    }

    private static void writeVarList(List<LogicalVariable> varList, List<Mutable<ILogicalExpression>> funcArgs) {
        MutableObject numKeysRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(varList.size()))));
        funcArgs.add((Mutable<ILogicalExpression>)numKeysRef);
        for (LogicalVariable keyVar : varList) {
            MutableObject keyVarRef = new MutableObject((Object)new VariableReferenceExpression(keyVar));
            funcArgs.add((Mutable<ILogicalExpression>)keyVarRef);
        }
    }

    private static void addStringArg(String argument, List<Mutable<ILogicalExpression>> funcArgs) {
        MutableObject stringRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(argument))));
        funcArgs.add((Mutable<ILogicalExpression>)stringRef);
    }

    public static UnnestMapOperator createExternalDataLookupUnnestMap(AbstractDataSourceOperator dataSourceOp, Dataset dataset, ARecordType recordType, ILogicalOperator inputOp, IOptimizationContext context, boolean retainInput, boolean retainNull) throws AlgebricksException {
        List<LogicalVariable> primaryKeyVars = AccessMethodUtils.getPrimaryKeyVarsFromSecondaryUnnestMap(dataset, inputOp);
        OrderOperator order = new OrderOperator();
        for (LogicalVariable pkVar : primaryKeyVars) {
            MutableObject vRef = new MutableObject((Object)new VariableReferenceExpression(pkVar));
            order.getOrderExpressions().add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)vRef));
        }
        order.getInputs().add(new MutableObject((Object)inputOp));
        order.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)order);
        ArrayList<Mutable<ILogicalExpression>> externalLookupArgs = new ArrayList<Mutable<ILogicalExpression>>();
        AccessMethodUtils.addStringArg(dataset.getDataverseName(), externalLookupArgs);
        AccessMethodUtils.addStringArg(dataset.getDatasetName(), externalLookupArgs);
        AccessMethodUtils.writeVarList(primaryKeyVars, externalLookupArgs);
        ArrayList externalUnnestVars = new ArrayList();
        ArrayList<Object> outputTypes = new ArrayList<Object>();
        externalUnnestVars.addAll(dataSourceOp.getVariables());
        AccessMethodUtils.appendExternalRecTypes(dataset, (IAType)recordType, outputTypes);
        IFunctionInfo externalLookup = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.EXTERNAL_LOOKUP);
        ScalarFunctionCallExpression externalLookupFunc = new ScalarFunctionCallExpression(externalLookup, externalLookupArgs);
        UnnestMapOperator unnestOp = new UnnestMapOperator(externalUnnestVars, (Mutable)new MutableObject((Object)externalLookupFunc), outputTypes, retainInput);
        unnestOp.getInputs().add(new MutableObject((Object)order));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestOp);
        unnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        DataSourceId dataSourceId = new DataSourceId(dataset.getDataverseName(), dataset.getDatasetName());
        unnestOp.setPhysicalOperator((IPhysicalOperator)new ExternalDataLookupPOperator(dataSourceId, dataset, recordType, primaryKeyVars, false, retainInput, retainNull));
        return unnestOp;
    }

    public static IAType constantRuntimeResultType(ILogicalExpression expr, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        HashSet usedVariables = new HashSet();
        expr.getUsedVariables(usedVariables);
        if (usedVariables.size() > 0) {
            return null;
        }
        return (IAType)context.getExpressionTypeComputer().getType(expr, context.getMetadataProvider(), typeEnvironment);
    }

    public static boolean retainInputs(List<LogicalVariable> dataSourceVariables, ILogicalOperator sourceOp, List<Mutable<ILogicalOperator>> afterSelectRefs) throws AlgebricksException {
        ArrayList usedVars = new ArrayList();
        ArrayList producedVars = new ArrayList();
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)sourceOp, liveVars);
        for (Mutable<ILogicalOperator> opMutable : afterSelectRefs) {
            ILogicalOperator op = (ILogicalOperator)opMutable.getValue();
            VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVars);
            VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
        }
        usedVars.removeAll(producedVars);
        usedVars.removeAll(dataSourceVariables);
        usedVars.retainAll(liveVars);
        return !usedVars.isEmpty();
    }
}

