/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.algebra.operators.physical.CommitPOperator;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorDelegate;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class SetupCommitExtensionOpRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return false;
        }
        DelegateOperator eOp = (DelegateOperator)op;
        if (!(eOp.getDelegate() instanceof CommitOperator)) {
            return false;
        }
        boolean isSink = ((CommitOperator)eOp.getDelegate()).isSink();
        List primaryKeyExprs = null;
        Dataset dataset = null;
        AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)eOp.getInputs().get(0)).getValue();
        while (descendantOp != null) {
            InsertDeleteUpsertOperator insertDeleteUpsertOperator;
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.INDEX_INSERT_DELETE_UPSERT) {
                IndexInsertDeleteUpsertOperator operator = (IndexInsertDeleteUpsertOperator)descendantOp;
                if (!operator.isBulkload() && operator.getPrevSecondaryKeyExprs() == null) {
                    primaryKeyExprs = operator.getPrimaryKeyExpressions();
                    dataset = ((DatasetDataSource)operator.getDataSourceIndex().getDataSource()).getDataset();
                    break;
                }
            } else if (descendantOp.getOperatorTag() == LogicalOperatorTag.INSERT_DELETE_UPSERT && !(insertDeleteUpsertOperator = (InsertDeleteUpsertOperator)descendantOp).isBulkload()) {
                primaryKeyExprs = insertDeleteUpsertOperator.getPrimaryKeyExpressions();
                dataset = ((DatasetDataSource)insertDeleteUpsertOperator.getDataSource()).getDataset();
                break;
            }
            if (descendantOp.getInputs().isEmpty()) break;
            descendantOp = (AbstractLogicalOperator)((Mutable)descendantOp.getInputs().get(0)).getValue();
        }
        if (primaryKeyExprs == null) {
            return false;
        }
        ArrayList<LogicalVariable> primaryKeyLogicalVars = new ArrayList<LogicalVariable>();
        for (Mutable expr : primaryKeyExprs) {
            VariableReferenceExpression varRefExpr = (VariableReferenceExpression)expr.getValue();
            primaryKeyLogicalVars.add(new LogicalVariable(varRefExpr.getVariableReference().getId()));
        }
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        JobId jobId = mp.getJobId();
        CommitOperator commitOperator = new CommitOperator(primaryKeyLogicalVars, isSink);
        CommitPOperator commitPOperator = new CommitPOperator(jobId, dataset, primaryKeyLogicalVars, isSink);
        commitOperator.setPhysicalOperator((IPhysicalOperator)commitPOperator);
        DelegateOperator extensionOperator = new DelegateOperator((IOperatorDelegate)commitOperator);
        extensionOperator.setPhysicalOperator((IPhysicalOperator)commitPOperator);
        extensionOperator.getInputs().add(eOp.getInputs().get(0));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)extensionOperator);
        opRef.setValue((Object)extensionOperator);
        return true;
    }
}

