/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;

public class PushLimitIntoOrderByRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (context.checkAndAddToAlreadyCompared((ILogicalOperator)op, (ILogicalOperator)op2)) {
            return false;
        }
        if (op2.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        boolean res = this.pushLimitIntoOrder(opRef, (Mutable<ILogicalOperator>)opRef2, context);
        if (res) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return res;
    }

    private boolean pushLimitIntoOrder(Mutable<ILogicalOperator> opRef, Mutable<ILogicalOperator> opRef2, IOptimizationContext context) throws AlgebricksException {
        PhysicalOptimizationConfig physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        LimitOperator limitOp = (LimitOperator)opRef.getValue();
        OrderOperator orderOp = (OrderOperator)opRef2.getValue();
        long topK = -1L;
        if (orderOp.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.STABLE_SORT) {
            return false;
        }
        if (((ILogicalExpression)limitOp.getMaxObjects().getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            topK = AccessMethodUtils.getInt64Constant((Mutable<ILogicalExpression>)limitOp.getMaxObjects());
            if (topK > Integer.MAX_VALUE) {
                return false;
            }
            if (topK < 0L) {
                topK = 0L;
            }
        } else {
            return false;
        }
        if (limitOp.getOffset().getValue() != null) {
            if (((ILogicalExpression)limitOp.getOffset().getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                long offset = AccessMethodUtils.getInt64Constant((Mutable<ILogicalExpression>)limitOp.getOffset());
                if (offset < 0L) {
                    offset = 0L;
                }
                if (offset >= Integer.MAX_VALUE - topK) {
                    return false;
                }
                topK += offset;
            } else {
                return false;
            }
        }
        OrderOperator newOrderOp = new OrderOperator(orderOp.getOrderExpressions(), (int)topK);
        newOrderOp.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(physicalOptimizationConfig.getMaxFramesExternalSort(), newOrderOp.getTopK()));
        newOrderOp.getInputs().addAll(orderOp.getInputs());
        newOrderOp.setExecutionMode(orderOp.getExecutionMode());
        newOrderOp.recomputeSchema();
        newOrderOp.computeDeliveredPhysicalProperties(context);
        opRef2.setValue((Object)newOrderOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newOrderOp);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)limitOp);
        return true;
    }
}

