/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushFieldAccessRule
implements IAlgebraicRewriteRule {
    private static final String IS_MOVABLE = "isMovable";

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        String finalAnnot;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator access = (AssignOperator)op;
        ILogicalExpression expr = this.getFirstExpr(access);
        if (AnalysisUtil.isAccessToFieldRecord(expr)) {
            finalAnnot = "PUSHED_FIELD_ACCESS";
        } else if (AnalysisUtil.isRunnableAccessToFieldRecord(expr)) {
            finalAnnot = "PUSHED_RUNNABLE_FIELD_ACCESS";
        } else {
            return false;
        }
        return this.propagateFieldAccessRec(opRef, context, finalAnnot);
    }

    private boolean isAccessToIndexedField(AssignOperator assign, IOptimizationContext context) throws AlgebricksException {
        DataSourceId asid;
        AbstractFunctionCallExpression accessFun = (AbstractFunctionCallExpression)((Mutable)assign.getExpressions().get(0)).getValue();
        ILogicalExpression e0 = (ILogicalExpression)((Mutable)accessFun.getArguments().get(0)).getValue();
        if (e0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable var = ((VariableReferenceExpression)e0).getVariableReference();
        if (context.findPrimaryKey(var) == null) {
            return false;
        }
        AssignOperator op = assign;
        while (op.getInputs().size() == 1 && op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return false;
        }
        DataSourceScanOperator scan = (DataSourceScanOperator)op;
        LogicalVariable recVar = (LogicalVariable)scan.getVariables().get(scan.getVariables().size() - 1);
        if (recVar != var) {
            return false;
        }
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = mp.findDataset((asid = (DataSourceId)scan.getDataSource().getId()).getDataverseName(), asid.getDatasourceName());
        if (dataset == null) {
            throw new AlgebricksException("Dataset " + asid.getDatasourceName() + " not found.");
        }
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return false;
        }
        Integer pos = ConstantExpressionUtil.getIntConstant((ILogicalExpression)((ILogicalExpression)((Mutable)accessFun.getArguments().get(1)).getValue()));
        if (pos != null) {
            String tName = dataset.getItemTypeName();
            IAType t = mp.findType(dataset.getItemTypeDataverseName(), tName);
            if (t.getTypeTag() != ATypeTag.RECORD) {
                return false;
            }
            ARecordType rt = (ARecordType)t;
            if (pos >= rt.getFieldNames().length) {
                return false;
            }
        }
        List datasetIndexes = mp.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        boolean hasSecondaryIndex = false;
        for (Index index : datasetIndexes) {
            if (!index.isSecondaryIndex()) continue;
            hasSecondaryIndex = true;
            break;
        }
        return hasSecondaryIndex;
    }

    private boolean tryingToPushThroughSelectionWithSameDataSource(AssignOperator access, AbstractLogicalOperator op2) {
        if (op2.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        ILogicalExpression e1 = (ILogicalExpression)access.getAnnotations().get("FIELD_ACCESS");
        if (e1 == null) {
            return false;
        }
        ILogicalExpression e2 = (ILogicalExpression)op2.getAnnotations().get("FIELD_ACCESS");
        if (e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    private boolean propagateFieldAccessRec(Mutable<ILogicalOperator> opRef, IOptimizationContext context, String finalAnnot) throws AlgebricksException {
        Object v2;
        AssignOperator access = (AssignOperator)opRef.getValue();
        Mutable opRef2 = (Mutable)access.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == LogicalOperatorTag.PROJECT || context.checkAndAddToAlreadyCompared((ILogicalOperator)access, (ILogicalOperator)op2) && (op2.getOperatorTag() != LogicalOperatorTag.SELECT || !this.isAccessToIndexedField(access, context))) {
            return false;
        }
        Object annotation = op2.getAnnotations().get(IS_MOVABLE);
        if (annotation != null && !((Boolean)annotation).booleanValue()) {
            return false;
        }
        if (this.tryingToPushThroughSelectionWithSameDataSource(access, op2)) {
            return false;
        }
        if (this.testAndModifyRedundantOp(access, op2)) {
            this.propagateFieldAccessRec((Mutable<ILogicalOperator>)opRef2, context, finalAnnot);
            return true;
        }
        LinkedList usedInAccess = new LinkedList();
        VariableUtilities.getUsedVariables((ILogicalOperator)access, usedInAccess);
        LinkedList produced2 = new LinkedList();
        if (op2.getOperatorTag() == LogicalOperatorTag.GROUP) {
            VariableUtilities.getLiveVariables((ILogicalOperator)op2, produced2);
        } else {
            VariableUtilities.getProducedVariables((ILogicalOperator)op2, produced2);
        }
        boolean pushItDown = false;
        ArrayList inter = new ArrayList(usedInAccess);
        if (inter.isEmpty()) {
            return false;
        }
        inter.retainAll(produced2);
        if (inter.isEmpty()) {
            pushItDown = true;
        } else if (op2.getOperatorTag() == LogicalOperatorTag.GROUP) {
            GroupByOperator g = (GroupByOperator)op2;
            ArrayList<Pair> varMappings = new ArrayList<Pair>();
            for (Object p : g.getDecorList()) {
                LogicalVariable decorVar;
                ILogicalExpression e = (ILogicalExpression)((Mutable)((Pair)p).second).getValue();
                if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE || !inter.contains(decorVar = GroupByOperator.getDecorVariable((Pair)p))) continue;
                inter.remove(decorVar);
                LogicalVariable v1 = ((VariableReferenceExpression)e).getVariableReference();
                varMappings.add(new Pair((Object)decorVar, (Object)v1));
            }
            if (inter.isEmpty()) {
                boolean changed = false;
                for (Pair m : varMappings) {
                    v2 = context.newVar();
                    LogicalVariable oldVar = (LogicalVariable)access.getVariables().get(0);
                    g.getDecorList().add(new Pair((Object)oldVar, (Object)new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)v2))));
                    changed = true;
                    access.getVariables().set(0, v2);
                    VariableUtilities.substituteVariables((ILogicalOperator)access, (LogicalVariable)((LogicalVariable)m.first), (LogicalVariable)((LogicalVariable)m.second), (ITypingContext)context);
                }
                if (changed) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)g);
                }
                usedInAccess.clear();
                VariableUtilities.getUsedVariables((ILogicalOperator)access, usedInAccess);
                pushItDown = true;
            }
        }
        if (pushItDown) {
            if (op2.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
                Mutable childOfSubplan = (Mutable)((ILogicalOperator)((NestedTupleSourceOperator)op2).getDataSourceReference().getValue()).getInputs().get(0);
                this.pushAccessDown(opRef, (ILogicalOperator)op2, (Mutable<ILogicalOperator>)childOfSubplan, context, finalAnnot);
                return true;
            }
            if (op2.getInputs().size() == 1 && !op2.hasNestedPlans()) {
                this.pushAccessDown(opRef, (ILogicalOperator)op2, (Mutable<ILogicalOperator>)((Mutable)op2.getInputs().get(0)), context, finalAnnot);
                return true;
            }
            for (Object inp : op2.getInputs()) {
                HashSet v22 = new HashSet();
                VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)inp.getValue()), v22);
                if (!v22.containsAll(usedInAccess)) continue;
                this.pushAccessDown(opRef, (ILogicalOperator)op2, (Mutable<ILogicalOperator>)inp, context, finalAnnot);
                return true;
            }
            if (op2.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans nestedOp = (AbstractOperatorWithNestedPlans)op2;
                for (ILogicalPlan plan : nestedOp.getNestedPlans()) {
                    for (Mutable root : plan.getRoots()) {
                        v2 = new HashSet();
                        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)root.getValue()), (Collection)v2);
                        if (!((AbstractCollection)v2).containsAll(usedInAccess)) continue;
                        this.pushAccessDown(opRef, (ILogicalOperator)op2, (Mutable<ILogicalOperator>)root, context, finalAnnot);
                        return true;
                    }
                }
            }
            throw new AlgebricksException("Field access " + ((Mutable)access.getExpressions().get(0)).getValue() + " does not correspond to any input of operator " + op2);
        }
        if (op2.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            ILogicalExpression e1;
            VariableReferenceExpression varRef;
            DataSourceScanOperator scan = (DataSourceScanOperator)op2;
            int n = scan.getVariables().size();
            LogicalVariable scanRecordVar = (LogicalVariable)scan.getVariables().get(n - 1);
            AbstractFunctionCallExpression accessFun = (AbstractFunctionCallExpression)((Mutable)access.getExpressions().get(0)).getValue();
            ILogicalExpression e0 = (ILogicalExpression)((Mutable)accessFun.getArguments().get(0)).getValue();
            LogicalExpressionTag tag = e0.getExpressionTag();
            if (tag == LogicalExpressionTag.VARIABLE && (varRef = (VariableReferenceExpression)e0).getVariableReference() == scanRecordVar && (e1 = (ILogicalExpression)((Mutable)accessFun.getArguments().get(1)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                String fldName;
                IDataSource dataSource = scan.getDataSource();
                byte dsType = ((DataSource)dataSource).getDatasourceType();
                if (dsType == 2 || dsType == 3) {
                    return false;
                }
                DataSourceId asid = (DataSourceId)dataSource.getId();
                MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
                Dataset dataset = mp.findDataset(asid.getDataverseName(), asid.getDatasourceName());
                if (dataset == null) {
                    throw new AlgebricksException("Dataset " + asid.getDatasourceName() + " not found.");
                }
                if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
                    this.setAsFinal((ILogicalOperator)access, context, finalAnnot);
                    return false;
                }
                ConstantExpression ce = (ConstantExpression)e1;
                IAObject obj = ((AsterixConstantValue)ce.getValue()).getObject();
                if (obj.getType().getTypeTag() == ATypeTag.STRING) {
                    fldName = ((AString)obj).getStringValue();
                } else {
                    int pos = ((AInt32)obj).getIntegerValue();
                    String tName = dataset.getItemTypeName();
                    IAType t = mp.findType(dataset.getItemTypeDataverseName(), tName);
                    if (t.getTypeTag() != ATypeTag.RECORD) {
                        return false;
                    }
                    ARecordType rt = (ARecordType)t;
                    if (pos >= rt.getFieldNames().length) {
                        this.setAsFinal((ILogicalOperator)access, context, finalAnnot);
                        return false;
                    }
                    fldName = rt.getFieldNames()[pos];
                }
                int p = DatasetUtil.getPositionOfPartitioningKeyField((Dataset)dataset, (String)fldName);
                if (p < 0) {
                    this.setAsFinal((ILogicalOperator)access, context, finalAnnot);
                    return false;
                }
                LogicalVariable keyVar = (LogicalVariable)scan.getVariables().get(p);
                ((Mutable)access.getExpressions().get(0)).setValue((Object)new VariableReferenceExpression(keyVar));
                return true;
            }
        }
        this.setAsFinal((ILogicalOperator)access, context, finalAnnot);
        return false;
    }

    private void setAsFinal(ILogicalOperator access, IOptimizationContext context, String finalAnnot) {
        access.getAnnotations().put(finalAnnot, true);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, access);
    }

    private boolean testAndModifyRedundantOp(AssignOperator access, AbstractLogicalOperator op2) {
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator a2 = (AssignOperator)op2;
        if (this.getFirstExpr(access).equals(this.getFirstExpr(a2))) {
            ((Mutable)access.getExpressions().get(0)).setValue((Object)new VariableReferenceExpression((LogicalVariable)a2.getVariables().get(0)));
            return true;
        }
        return false;
    }

    private void pushAccessDown(Mutable<ILogicalOperator> fldAccessOpRef, ILogicalOperator op2, Mutable<ILogicalOperator> inputOfOp2, IOptimizationContext context, String finalAnnot) throws AlgebricksException {
        ILogicalOperator fieldAccessOp = (ILogicalOperator)fldAccessOpRef.getValue();
        fldAccessOpRef.setValue((Object)op2);
        List faInpList = fieldAccessOp.getInputs();
        faInpList.clear();
        faInpList.add(new MutableObject(inputOfOp2.getValue()));
        inputOfOp2.setValue((Object)fieldAccessOp);
        context.computeAndSetTypeEnvironmentForOperator(fieldAccessOp);
        context.computeAndSetTypeEnvironmentForOperator(op2);
        this.propagateFieldAccessRec(inputOfOp2, context, finalAnnot);
    }

    private ILogicalExpression getFirstExpr(AssignOperator assign) {
        return (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
    }
}

