/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.ILogicalExpressionReferenceTransformWithCondition;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

class MetaKeyToFieldAccessTransform
implements ILogicalExpressionReferenceTransformWithCondition {
    private final LogicalVariable metaVar;

    MetaKeyToFieldAccessTransform(LogicalVariable recordVar) {
        this.metaVar = recordVar;
    }

    public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        FunctionIdentifier functionIdentifier;
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.META_KEY)) {
            return false;
        }
        List args = funcExpr.getArguments();
        ConstantExpression fieldNameExpression = (ConstantExpression)((Mutable)args.get(1)).getValue();
        AsterixConstantValue fieldNameValue = (AsterixConstantValue)fieldNameExpression.getValue();
        IAType fieldNameType = fieldNameValue.getObject().getType();
        switch (fieldNameType.getTypeTag()) {
            case ORDEREDLIST: {
                functionIdentifier = BuiltinFunctions.FIELD_ACCESS_NESTED;
                break;
            }
            case STRING: {
                functionIdentifier = BuiltinFunctions.FIELD_ACCESS_BY_NAME;
                break;
            }
            default: {
                throw new AlgebricksException("Unsupported field name type " + fieldNameType.getTypeTag());
            }
        }
        IFunctionInfo finfoAccess = FunctionUtil.getFunctionInfo((FunctionIdentifier)functionIdentifier);
        ArrayList<MutableObject> argExprs = new ArrayList<MutableObject>(2);
        argExprs.add(new MutableObject((Object)new VariableReferenceExpression(this.metaVar)));
        argExprs.add(new MutableObject((Object)fieldNameExpression));
        exprRef.setValue((Object)new ScalarFunctionCallExpression(finfoAccess, argExprs));
        return true;
    }
}

