/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.dataflow.data.common.TypeResolverUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class InjectTypeCastForSwitchCaseRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getInputs().isEmpty()) {
            return false;
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
        if (op.acceptExpressionTransform(exprRef -> this.injectTypeCast(op, (Mutable<ILogicalExpression>)exprRef, context))) {
            context.computeAndSetTypeEnvironmentForOperator(op);
            return true;
        }
        return false;
    }

    private boolean injectTypeCast(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean rewritten = false;
        AbstractFunctionCallExpression func = (AbstractFunctionCallExpression)expr;
        for (Mutable argRef : func.getArguments()) {
            if (!this.injectTypeCast(op, (Mutable<ILogicalExpression>)argRef, context)) continue;
            context.computeAndSetTypeEnvironmentForOperator(op);
            rewritten = true;
        }
        if (!func.getFunctionIdentifier().equals((Object)BuiltinFunctions.SWITCH_CASE)) {
            return rewritten;
        }
        return this.rewriteSwitchCase(op, func, context);
    }

    private boolean rewriteSwitchCase(ILogicalOperator op, AbstractFunctionCallExpression func, IOptimizationContext context) throws AlgebricksException {
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
        IAType producedType = (IAType)env.getType((ILogicalExpression)func);
        List argRefs = func.getArguments();
        int argSize = argRefs.size();
        boolean rewritten = false;
        for (int argIndex = 2; argIndex < argSize; argIndex += argIndex + 2 == argSize ? 1 : 2) {
            Mutable argRef = (Mutable)argRefs.get(argIndex);
            IAType type = (IAType)env.getType((ILogicalExpression)((Mutable)argRefs.get(argIndex)).getValue());
            if (!TypeResolverUtil.needsCast((IAType)producedType, (IAType)type)) continue;
            ILogicalExpression argExpr = (ILogicalExpression)argRef.getValue();
            ScalarFunctionCallExpression castFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)argExpr))));
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castFunc, (IAType)producedType, (IAType)type);
            argRef.setValue((Object)castFunc);
            rewritten = true;
        }
        return rewritten;
    }
}

