/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.runtime.evaluators.functions.FullTextContainsDescriptor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FullTextContainsParameterCheckRule
implements IAlgebraicRewriteRule {
    HashMap<MutableObject<ILogicalExpression>, MutableObject<ILogicalExpression>> paramValueMap;
    private static final int LAST_EXPRESSION_POS_BEFORE_OPTION = 1;
    private static final int FULLTEXT_QUERY_WITHOUT_OPTION_NO_OF_ARGUMENTS = 2;
    private static final int FULLTEXT_QUERY_WITH_OPTION_NO_OF_ARGUMENTS = 3;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        Mutable exprRef;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case SELECT: {
                exprRef = ((SelectOperator)op).getCondition();
                break;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                exprRef = ((AbstractBinaryJoinOperator)op).getCondition();
                break;
            }
            default: {
                return false;
            }
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (this.checkParamter((ILogicalOperator)op, (Mutable<ILogicalExpression>)exprRef, context)) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
            return true;
        }
        return false;
    }

    private boolean checkParamter(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fi = funcExpr.getFunctionIdentifier();
        int numberOfCorrectArguments = 0;
        String functionName = "";
        if (fi == BuiltinFunctions.FULLTEXT_CONTAINS) {
            numberOfCorrectArguments = 3;
            functionName = BuiltinFunctions.FULLTEXT_CONTAINS.getName();
        } else if (fi == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
            numberOfCorrectArguments = 2;
            functionName = BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION.getName();
        }
        if (numberOfCorrectArguments > 0) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
            List oldExprs = funcExpr.getArguments();
            ArrayList<Mutable<ILogicalExpression>> newExprs = new ArrayList<Mutable<ILogicalExpression>>();
            if (oldExprs.size() != numberOfCorrectArguments) {
                throw new AlgebricksException(functionName + " should have " + numberOfCorrectArguments + " parameters.");
            }
            for (int i = 0; i <= 1; ++i) {
                newExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)((ILogicalExpression)((Mutable)oldExprs.get(i)).getValue())));
            }
            this.checkFirstAndSecondParamter(oldExprs, functionName);
            if (numberOfCorrectArguments == 3) {
                this.checkValueForThirdParameter((Mutable<ILogicalExpression>)((Mutable)oldExprs.get(2)), newExprs);
            } else {
                this.setDefaultValueForThirdParameter(newExprs);
            }
            funcExpr.getArguments().clear();
            funcExpr.getArguments().addAll(newExprs);
            return true;
        }
        return false;
    }

    void checkFirstAndSecondParamter(List<Mutable<ILogicalExpression>> exprs, String functionName) throws AlgebricksException {
        ILogicalExpression firstExpr = (ILogicalExpression)exprs.get(0).getValue();
        if (firstExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT && ConstantExpressionUtil.getConstantIaObjectType((ILogicalExpression)firstExpr) != ATypeTag.STRING) {
            throw new AlgebricksException("The first expression of " + functionName + " should be a string.");
        }
        ILogicalExpression secondExpr = (ILogicalExpression)exprs.get(1).getValue();
        if (secondExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            ATypeTag exprTypeTag = ConstantExpressionUtil.getConstantIaObjectType((ILogicalExpression)secondExpr);
            switch (exprTypeTag) {
                case STRING: 
                case UNORDEREDLIST: 
                case ORDEREDLIST: {
                    break;
                }
                default: {
                    throw new AlgebricksException("The second expression of " + functionName + "should be a string, an unordered list, or an ordered list.");
                }
            }
        }
    }

    void checkValueForThirdParameter(Mutable<ILogicalExpression> expr, List<Mutable<ILogicalExpression>> newArgs) throws AlgebricksException {
        AbstractFunctionCallExpression openRecConsExpr = (AbstractFunctionCallExpression)expr.getValue();
        FunctionIdentifier openRecConsFi = openRecConsExpr.getFunctionIdentifier();
        if (openRecConsFi != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR && openRecConsFi != BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR) {
            throw new AlgebricksException("ftcontains() option should be the form of a record { }.");
        }
        if (openRecConsExpr.getArguments().size() > FullTextContainsDescriptor.getParamTypeMap().size() * 2) {
            throw new AlgebricksException("Too many options were specified.");
        }
        for (int i = 0; i < openRecConsExpr.getArguments().size(); i += 2) {
            ILogicalExpression optionExpr = (ILogicalExpression)((Mutable)openRecConsExpr.getArguments().get(i)).getValue();
            ILogicalExpression optionExprVal = (ILogicalExpression)((Mutable)openRecConsExpr.getArguments().get(i + 1)).getValue();
            if (optionExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                throw new AlgebricksException("Options must be in the form of constant strings. Check that the option at " + (i % 2 + 1) + " is indeed a constant string");
            }
            String option = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)openRecConsExpr, (int)i).toLowerCase();
            if (!FullTextContainsDescriptor.getParamTypeMap().containsKey(option)) {
                throw new AlgebricksException("The given option " + option + " is not a valid argument to ftcontains()");
            }
            boolean typeError = false;
            String optionTypeStringVal = null;
            if (optionExprVal.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                switch ((ATypeTag)FullTextContainsDescriptor.getParamTypeMap().get(option)) {
                    case STRING: {
                        optionTypeStringVal = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)openRecConsExpr, (int)(i + 1)).toLowerCase();
                        if (optionTypeStringVal != null) break;
                        typeError = true;
                        break;
                    }
                    default: {
                        typeError = true;
                    }
                }
            }
            if (typeError) {
                throw new AlgebricksException("The given value for option " + option + " was not of the expected type");
            }
            switch (option) {
                case "mode": {
                    this.checkSearchModeOption(optionTypeStringVal);
                    break;
                }
            }
            newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)optionExpr));
            newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)optionExprVal));
        }
    }

    void checkSearchModeOption(String optionVal) throws AlgebricksException {
        if (optionVal.equals("all") || optionVal.equals("any")) {
            return;
        }
        throw new AlgebricksException("The given value for the search mode (" + optionVal + ") is not valid. Valid modes are " + "all" + " or " + "any" + ".");
    }

    void setDefaultValueForThirdParameter(List<Mutable<ILogicalExpression>> newArgs) throws AlgebricksException {
        ConstantExpression searchModeOptionExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("mode")));
        ConstantExpression searchModeValExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("all")));
        newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)searchModeOptionExpr));
        newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)searchModeValExpr));
    }
}

