/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.algebra.operators.physical.IndexSearchPOperator;
import org.apache.asterix.common.dataflow.IApplicationContextInfo;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.InvertedIndexJobGenParams;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;

public class InvertedIndexPOperator
extends IndexSearchPOperator {
    private final boolean isPartitioned;

    public InvertedIndexPOperator(IDataSourceIndex<String, DataSourceId> idx, INodeDomain domain, boolean requiresBroadcast, boolean isPartitioned) {
        super(idx, domain, requiresBroadcast);
        this.isPartitioned = isPartitioned;
    }

    public PhysicalOperatorTag getOperatorTag() {
        if (this.isPartitioned) {
            return PhysicalOperatorTag.LENGTH_PARTITIONED_INVERTED_INDEX_SEARCH;
        }
        return PhysicalOperatorTag.SINGLE_PARTITION_INVERTED_INDEX_SEARCH;
    }

    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        Dataset dataset;
        AbstractUnnestMapOperator unnestMapOp = (AbstractUnnestMapOperator)op;
        ILogicalExpression unnestExpr = (ILogicalExpression)unnestMapOp.getExpressionRef().getValue();
        if (unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            throw new IllegalStateException();
        }
        AbstractFunctionCallExpression unnestFuncExpr = (AbstractFunctionCallExpression)unnestExpr;
        if (unnestFuncExpr.getFunctionIdentifier() != BuiltinFunctions.INDEX_SEARCH) {
            return;
        }
        InvertedIndexJobGenParams jobGenParams = new InvertedIndexJobGenParams();
        jobGenParams.readFromFuncArgs(unnestFuncExpr.getArguments());
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        try {
            dataset = metadataProvider.findDataset(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        int[] keyIndexes = this.getKeyIndexes(jobGenParams.getKeyVarList(), inputSchemas);
        int[] minFilterFieldIndexes = this.getKeyIndexes(unnestMapOp.getMinFilterVars(), inputSchemas);
        int[] maxFilterFieldIndexes = this.getKeyIndexes(unnestMapOp.getMaxFilterVars(), inputSchemas);
        boolean retainNull = false;
        if (op.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) {
            retainNull = true;
        }
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> invIndexSearch = this.buildInvertedIndexRuntime(metadataProvider, context, builder.getJobSpec(), unnestMapOp, opSchema, jobGenParams.getRetainInput(), retainNull, jobGenParams.getDatasetName(), dataset, jobGenParams.getIndexName(), jobGenParams.getSearchKeyType(), keyIndexes, jobGenParams.getSearchModifierType(), jobGenParams.getSimilarityThreshold(), minFilterFieldIndexes, maxFilterFieldIndexes, jobGenParams.getIsFullTextSearch());
        builder.contributeHyracksOperator((ILogicalOperator)unnestMapOp, (IOperatorDescriptor)invIndexSearch.first);
        builder.contributeAlgebricksPartitionConstraint((IOperatorDescriptor)invIndexSearch.first, (AlgebricksPartitionConstraint)invIndexSearch.second);
        ILogicalOperator srcExchange = (ILogicalOperator)((Mutable)unnestMapOp.getInputs().get(0)).getValue();
        builder.contributeGraphEdge(srcExchange, 0, (ILogicalOperator)unnestMapOp, 0);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildInvertedIndexRuntime(MetadataProvider metadataProvider, JobGenContext context, JobSpecification jobSpec, AbstractUnnestMapOperator unnestMap, IOperatorSchema opSchema, boolean retainInput, boolean retainMissing, String datasetName, Dataset dataset, String indexName, ATypeTag searchKeyType, int[] keyFields, InvertedIndexAccessMethod.SearchModifierType searchModifierType, IAlgebricksConstantValue similarityThreshold, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, boolean isFullTextSearchQuery) throws AlgebricksException {
        try {
            IAObject simThresh = ((AsterixConstantValue)similarityThreshold).getObject();
            IAType itemType = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName()).getDatatype();
            int numPrimaryKeys = DatasetUtil.getPartitioningKeys((Dataset)dataset).size();
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex == null) {
                throw new AlgebricksException("Code generation error: no index " + indexName + " for dataset " + datasetName);
            }
            List secondaryKeyFieldEntries = secondaryIndex.getKeyFieldNames();
            List secondaryKeyTypeEntries = secondaryIndex.getKeyFieldTypes();
            int numSecondaryKeys = secondaryKeyFieldEntries.size();
            if (numSecondaryKeys != 1) {
                throw new AlgebricksException("Cannot use " + numSecondaryKeys + " fields as a key for an inverted index. There can be only one field as a key for the inverted index index.");
            }
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be indexed.");
            }
            ARecordType recordType = (ARecordType)itemType;
            Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)((IAType)secondaryKeyTypeEntries.get(0)), (List)((List)secondaryKeyFieldEntries.get(0)), (ARecordType)recordType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            if (secondaryKeyType == null) {
                throw new AlgebricksException("Could not find field " + secondaryKeyFieldEntries.get(0) + " in the schema.");
            }
            int numTokenKeys = !this.isPartitioned ? numSecondaryKeys : numSecondaryKeys + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenKeys];
            IBinaryComparatorFactory[] tokenComparatorFactories = new IBinaryComparatorFactory[numTokenKeys];
            for (int i = 0; i < numSecondaryKeys; ++i) {
                tokenComparatorFactories[i] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)secondaryKeyType);
                tokenTypeTraits[i] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            }
            if (this.isPartitioned) {
                tokenComparatorFactories[numSecondaryKeys] = PointableBinaryComparatorFactory.of((IPointableFactory)ShortPointable.FACTORY);
                tokenTypeTraits[numSecondaryKeys] = ShortPointable.TYPE_TRAITS;
            }
            IVariableTypeEnvironment typeEnv = context.getTypeEnvironment((ILogicalOperator)unnestMap);
            ArrayList outputVars = unnestMap.getVariables();
            if (retainInput) {
                outputVars = new ArrayList();
                VariableUtilities.getLiveVariables((ILogicalOperator)unnestMap, outputVars);
            }
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            int start = outputRecDesc.getFieldCount() - numPrimaryKeys;
            IBinaryComparatorFactory[] invListsComparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(outputVars, (int)start, (int)numPrimaryKeys, (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            ITypeTraits[] invListsTypeTraits = JobGenHelper.variablesToTypeTraits(outputVars, (int)start, (int)numPrimaryKeys, (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            ITypeTraits[] filterTypeTraits = DatasetUtil.computeFilterTypeTraits((Dataset)dataset, (ARecordType)recordType);
            if (filterTypeTraits != null) {
                int k;
                int[] filterFields = new int[]{numTokenKeys + numPrimaryKeys};
                int[] invertedIndexFields = new int[numTokenKeys + numPrimaryKeys];
                for (k = 0; k < invertedIndexFields.length; ++k) {
                    invertedIndexFields[k] = k;
                }
                int[] filterFieldsForNonBulkLoadOps = new int[]{numPrimaryKeys + numSecondaryKeys};
                int[] invertedIndexFieldsForNonBulkLoadOps = new int[numPrimaryKeys + numSecondaryKeys];
                for (k = 0; k < invertedIndexFieldsForNonBulkLoadOps.length; ++k) {
                    invertedIndexFieldsForNonBulkLoadOps[k] = k;
                }
            }
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair secondarySplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset, indexName);
            int queryField = keyFields[0];
            IInvertedIndexSearchModifierFactory searchModifierFactory = InvertedIndexAccessMethod.getSearchModifierFactory(searchModifierType, simThresh, secondaryIndex);
            IBinaryTokenizerFactory queryTokenizerFactory = InvertedIndexAccessMethod.getBinaryTokenizerFactory(searchModifierType, searchKeyType, secondaryIndex);
            ARecordType metaType = dataset.hasMetaPart() ? (ARecordType)metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName()).getType() : null;
            Pair compactionInfo = DatasetUtil.getMergePolicyFactory((Dataset)dataset, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            IIndexDataflowHelperFactory dataflowHelperFactory = dataset.getIndexDataflowHelperFactory(metadataProvider, secondaryIndex, recordType, metaType, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
            LSMInvertedIndexSearchOperatorDescriptor invIndexSearchOp = new LSMInvertedIndexSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, queryField, appContext.getStorageManager(), (IFileSplitProvider)secondarySplitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListsComparatorFactories, dataflowHelperFactory, queryTokenizerFactory, searchModifierFactory, outputRecDesc, retainInput, retainMissing, context.getMissingWriterFactory(), dataset.getSearchCallbackFactory(metadataProvider.getStorageComponentProvider(), secondaryIndex, ((JobEventListenerFactory)jobSpec.getJobletEventListenerFactory()).getJobId(), IndexOperation.SEARCH, null), minFilterFieldIndexes, maxFilterFieldIndexes, (IPageManagerFactory)metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory(), isFullTextSearchQuery);
            return new Pair((Object)invIndexSearchOp, secondarySplitsAndConstraint.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }
}

