/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.HashMap;
import java.util.Map;

public class StorageUtil {
    private static final int BASE = 1024;

    private StorageUtil() {
        throw new AssertionError((Object)"This util class should not be initialized.");
    }

    public static int getIntSizeInBytes(int size, StorageUnit unit) {
        double result = unit.toBytes(size);
        if (result > 2.147483647E9 || result < -2.147483648E9) {
            throw new IllegalArgumentException("The given value:" + result + " is not within the integer range.");
        }
        return (int)result;
    }

    public static long getLongSizeInBytes(long size, StorageUnit unit) {
        double result = unit.toBytes(size);
        if (result > 9.223372036854776E18 || result < -9.223372036854776E18) {
            throw new IllegalArgumentException("The given value:" + result + " is not within the long range.");
        }
        return (long)result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getSizeInBytes(String s) {
        StorageUnit unitType;
        String sSpaceRemoved = s.replaceAll(" ", "");
        String sUpper = sSpaceRemoved.toUpperCase();
        if (sUpper.length() == 1) {
            if (!Character.isDigit(sUpper.charAt(0))) throw StorageUtil.invalidFormatException(s);
            unitType = StorageUnit.BYTE;
        } else {
            if (sUpper.length() <= 1) throw StorageUtil.invalidFormatException(s);
            String checkStr = sUpper.substring(sUpper.length() - 2);
            unitType = StorageUnit.lookupBySuffix(checkStr);
            if (unitType == null) {
                char lastChar = sUpper.charAt(sUpper.length() - 1);
                if (!sUpper.substring(sUpper.length() - 1).equals(StorageUnit.BYTE.toString()) && !Character.isDigit(lastChar)) throw StorageUtil.invalidFormatException(s);
                unitType = StorageUnit.BYTE;
            }
        }
        String sFinalVal = sUpper.replaceAll("[^-\\.0123456789]", "");
        return unitType.toBytes(Double.parseDouble(sFinalVal));
    }

    private static IllegalArgumentException invalidFormatException(String s) {
        return new IllegalArgumentException("The given string: " + s + " is not a byte unit string (e.g., 320KB or 1024).");
    }

    public static long getByteValue(String s) {
        double result = StorageUtil.getSizeInBytes(s);
        if (result > 9.223372036854776E18 || result < -9.223372036854776E18) {
            throw new IllegalArgumentException("The given value:" + result + " is not within the long range.");
        }
        return (long)result;
    }

    public static String toHumanReadableSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int baseValue = (63 - Long.numberOfLeadingZeros(bytes)) / 10;
        char bytePrefix = " kMGTPE".charAt(baseValue);
        long divisor = 1L << baseValue * 10;
        if (bytes % divisor == 0L) {
            return String.format("%d %sB", bytes / divisor, Character.valueOf(bytePrefix));
        }
        return String.format("%.2f %sB", (double)bytes / (double)divisor, Character.valueOf(bytePrefix));
    }

    public static enum StorageUnit {
        BYTE("B", 1L),
        KILOBYTE("KB", 1024L),
        MEGABYTE("MB", StorageUnit.KILOBYTE.multiplier * 1024L),
        GIGABYTE("GB", StorageUnit.MEGABYTE.multiplier * 1024L),
        TERABYTE("TB", StorageUnit.GIGABYTE.multiplier * 1024L),
        PETABYTE("PB", StorageUnit.TERABYTE.multiplier * 1024L);

        private final String unitTypeInLetter;
        private final long multiplier;
        private static final Map<String, StorageUnit> SUFFIX_TO_UNIT_MAP;

        private StorageUnit(String unitTypeInLetter, long multiplier) {
            this.unitTypeInLetter = unitTypeInLetter;
            this.multiplier = multiplier;
        }

        public String toString() {
            return this.unitTypeInLetter;
        }

        public double toBytes(double value) {
            return value * (double)this.multiplier;
        }

        public static StorageUnit lookupBySuffix(String name) {
            return SUFFIX_TO_UNIT_MAP.get(name);
        }

        static {
            SUFFIX_TO_UNIT_MAP = new HashMap<String, StorageUnit>();
            for (StorageUnit unit : StorageUnit.values()) {
                SUFFIX_TO_UNIT_MAP.put(unit.unitTypeInLetter, unit);
            }
        }
    }
}

