/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;

public abstract class LSMTreeIndexAccessor
implements ILSMIndexAccessor {
    protected ILSMHarness lsmHarness;
    protected ILSMIndexOperationContext ctx;

    public LSMTreeIndexAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
        this.lsmHarness = lsmHarness;
        this.ctx = ctx;
    }

    public void insert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void update(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.UPDATE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void upsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    @Override
    public boolean tryInsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.INSERT);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.DELETE);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryUpdate(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.UPDATE);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryUpsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.SEARCH);
        this.lsmHarness.search(this.ctx, cursor, searchPred);
    }

    @Override
    public void flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        this.lsmHarness.flush(this.ctx, operation);
    }

    @Override
    public void merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.MERGE);
        this.lsmHarness.merge(this.ctx, operation);
    }

    @Override
    public void physicalDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.PHYSICALDELETE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    @Override
    public void scheduleFlush(ILSMIOOperationCallback callback) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.FLUSH);
        this.lsmHarness.scheduleFlush(this.ctx, callback);
    }

    @Override
    public void scheduleMerge(ILSMIOOperationCallback callback, List<ILSMDiskComponent> components) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.MERGE);
        this.ctx.getComponentsToBeMerged().clear();
        this.ctx.getComponentsToBeMerged().addAll(components);
        this.lsmHarness.scheduleMerge(this.ctx, callback);
    }

    @Override
    public void scheduleReplication(List<ILSMDiskComponent> lsmComponents, boolean bulkload, LSMOperationType opType) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.REPLICATE);
        this.ctx.getComponentsToBeReplicated().clear();
        this.ctx.getComponentsToBeReplicated().addAll(lsmComponents);
        this.lsmHarness.scheduleReplication(this.ctx, lsmComponents, bulkload, opType);
    }

    @Override
    public void scheduleFullMerge(ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.FULL_MERGE);
        this.lsmHarness.scheduleFullMerge(this.ctx, callback);
    }

    @Override
    public void forcePhysicalDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.PHYSICALDELETE);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceInsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceUpsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void updateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.updateMeta(this.ctx, key, value);
    }

    @Override
    public void forceUpdateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.forceUpdateMeta(this.ctx, key, value);
    }
}

