/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public abstract class LSMIndexSearchCursor
implements ITreeIndexCursor {
    protected final ILSMIndexOperationContext opCtx;
    protected final boolean returnDeletedTuples;
    protected PriorityQueueElement outputElement;
    protected IIndexCursor[] rangeCursors;
    protected PriorityQueueElement[] pqes;
    protected PriorityQueue<PriorityQueueElement> outputPriorityQueue;
    protected PriorityQueueComparator pqCmp;
    protected MultiComparator cmp;
    protected boolean needPush;
    protected boolean includeMutableComponent;
    protected ILSMHarness lsmHarness;
    protected List<ILSMComponent> operationalComponents;

    public LSMIndexSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples) {
        this.opCtx = opCtx;
        this.returnDeletedTuples = returnDeletedTuples;
        this.outputElement = null;
        this.needPush = false;
    }

    public ILSMIndexOperationContext getOpCtx() {
        return this.opCtx;
    }

    public void initPriorityQueue() throws HyracksDataException, IndexException {
        int pqInitSize;
        int n = pqInitSize = this.rangeCursors.length > 0 ? this.rangeCursors.length : 1;
        if (this.outputPriorityQueue == null) {
            int i;
            this.outputPriorityQueue = new PriorityQueue<PriorityQueueElement>(pqInitSize, this.pqCmp);
            this.pqes = new PriorityQueueElement[pqInitSize];
            for (i = 0; i < pqInitSize; ++i) {
                this.pqes[i] = new PriorityQueueElement(i);
            }
            for (i = 0; i < this.rangeCursors.length; ++i) {
                this.pushIntoPriorityQueue(this.pqes[i]);
            }
        } else {
            this.outputPriorityQueue.clear();
            if (pqInitSize == this.pqes.length) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.pqes[i].reset(null);
                    this.pushIntoPriorityQueue(this.pqes[i]);
                }
            } else {
                this.pqes = new PriorityQueueElement[pqInitSize];
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.pqes[i] = new PriorityQueueElement(i);
                    this.pushIntoPriorityQueue(this.pqes[i]);
                }
            }
        }
    }

    public IIndexCursor getCursor(int cursorIndex) {
        return this.rangeCursors[cursorIndex];
    }

    public void reset() throws HyracksDataException, IndexException {
        this.outputElement = null;
        this.needPush = false;
        try {
            if (this.outputPriorityQueue != null) {
                this.outputPriorityQueue.clear();
            }
            if (this.rangeCursors != null) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].reset();
                }
            }
            this.rangeCursors = null;
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public boolean hasNext() throws HyracksDataException, IndexException {
        this.checkPriorityQueue();
        return !this.outputPriorityQueue.isEmpty();
    }

    public void next() throws HyracksDataException {
        this.outputElement = this.outputPriorityQueue.poll();
        this.needPush = true;
    }

    public ICachedPage getPage() {
        return null;
    }

    public void close() throws HyracksDataException {
        try {
            if (this.outputPriorityQueue != null) {
                this.outputPriorityQueue.clear();
            }
            for (int i = 0; i < this.rangeCursors.length; ++i) {
                this.rangeCursors[i].close();
            }
            this.rangeCursors = null;
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public void setBufferCache(IBufferCache bufferCache) {
    }

    public void setFileId(int fileId) {
    }

    public ITupleReference getTuple() {
        return this.outputElement.getTuple();
    }

    protected boolean pushIntoPriorityQueue(PriorityQueueElement e) throws HyracksDataException, IndexException {
        int cursorIndex = e.getCursorIndex();
        if (this.rangeCursors[cursorIndex].hasNext()) {
            this.rangeCursors[cursorIndex].next();
            e.reset(this.rangeCursors[cursorIndex].getTuple());
            this.outputPriorityQueue.offer(e);
            return true;
        }
        this.rangeCursors[cursorIndex].close();
        return false;
    }

    protected boolean isDeleted(PriorityQueueElement checkElement) throws HyracksDataException, IndexException {
        return ((ILSMTreeTupleReference)checkElement.getTuple()).isAntimatter();
    }

    protected void checkPriorityQueue() throws HyracksDataException, IndexException {
        while (!this.outputPriorityQueue.isEmpty() || this.needPush) {
            if (!this.outputPriorityQueue.isEmpty()) {
                PriorityQueueElement checkElement = this.outputPriorityQueue.peek();
                if (this.outputElement == null) {
                    if (!this.isDeleted(checkElement) || this.returnDeletedTuples) break;
                    this.outputElement = this.outputPriorityQueue.poll();
                    this.needPush = true;
                    continue;
                }
                if (this.compare(this.cmp, this.outputElement.getTuple(), checkElement.getTuple()) == 0) {
                    PriorityQueueElement e = this.outputPriorityQueue.poll();
                    this.pushIntoPriorityQueue(e);
                    continue;
                }
                if (this.needPush) {
                    this.pushIntoPriorityQueue(this.outputElement);
                    this.needPush = false;
                }
                this.outputElement = null;
                continue;
            }
            this.pushIntoPriorityQueue(this.outputElement);
            this.needPush = false;
            this.outputElement = null;
        }
    }

    public boolean exclusiveLatchNodes() {
        return false;
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueComparator(this.cmp);
        }
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return cmp.compare(tupleA, tupleB);
    }

    public void markCurrentTupleAsUpdated() throws HyracksDataException {
        throw new HyracksDataException("Updating tuples is not supported with this cursor.");
    }

    public class PriorityQueueComparator
    implements Comparator<PriorityQueueElement> {
        protected MultiComparator cmp;

        public PriorityQueueComparator(MultiComparator cmp) {
            this.cmp = cmp;
        }

        @Override
        public int compare(PriorityQueueElement elementA, PriorityQueueElement elementB) {
            try {
                int result = this.cmp.compare(elementA.getTuple(), elementB.getTuple());
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            if (elementA.getCursorIndex() > elementB.getCursorIndex()) {
                return 1;
            }
            return -1;
        }

        public MultiComparator getMultiComparator() {
            return this.cmp;
        }
    }

    public class PriorityQueueElement {
        private ITupleReference tuple = null;
        private int cursorIndex;

        public PriorityQueueElement(int cursorIndex) {
            this.cursorIndex = cursorIndex;
        }

        public ITupleReference getTuple() {
            return this.tuple;
        }

        public int getCursorIndex() {
            return this.cursorIndex;
        }

        public void reset(ITupleReference tuple) {
            this.tuple = tuple;
        }
    }
}

