/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;

public class BlockingIOOperationCallbackWrapper
implements ILSMIOOperationCallback {
    private boolean notified = false;
    private final ILSMIOOperationCallback wrappedCallback;

    public BlockingIOOperationCallbackWrapper(ILSMIOOperationCallback callback) {
        this.wrappedCallback = callback;
    }

    public synchronized void waitForIO() throws InterruptedException {
        if (!this.notified) {
            this.wait();
        }
        this.notified = false;
    }

    @Override
    public void beforeOperation(LSMOperationType opType) throws HyracksDataException {
        this.wrappedCallback.beforeOperation(opType);
    }

    @Override
    public void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        this.wrappedCallback.afterOperation(opType, oldComponents, newComponent);
    }

    @Override
    public synchronized void afterFinalize(LSMOperationType opType, ILSMDiskComponent newComponent) throws HyracksDataException {
        this.wrappedCallback.afterFinalize(opType, newComponent);
        this.notifyAll();
        this.notified = true;
    }

    @Override
    public void setNumOfMutableComponents(int count) {
        this.wrappedCallback.setNumOfMutableComponents(count);
    }
}

