/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIOOperationTask;

public class AsynchronousScheduler
implements ILSMIOOperationScheduler {
    public static final AsynchronousScheduler INSTANCE = new AsynchronousScheduler();
    private ExecutorService executor;
    private final Map<String, ILSMIOOperation> runningFlushOperations = new HashMap<String, ILSMIOOperation>();
    private final Map<String, PriorityQueue<ILSMIOOperation>> waitingFlushOperations = new HashMap<String, PriorityQueue<ILSMIOOperation>>();

    public void init(ThreadFactory threadFactory) {
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), threadFactory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new LSMIOOperationTask<T>(callable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                LSMIOOperationTask task = (LSMIOOperationTask)r;
                ILSMIOOperation executedOp = task.getOperation();
                String id = executedOp.getIndexUniqueIdentifier();
                1 var6_6 = this;
                synchronized (var6_6) {
                    AsynchronousScheduler.this.runningFlushOperations.remove(id);
                    if (AsynchronousScheduler.this.waitingFlushOperations.containsKey(id)) {
                        try {
                            ILSMIOOperation op = (ILSMIOOperation)((PriorityQueue)AsynchronousScheduler.this.waitingFlushOperations.get(id)).poll();
                            if (op != null) {
                                AsynchronousScheduler.this.scheduleOperation(op);
                            } else {
                                AsynchronousScheduler.this.waitingFlushOperations.remove(id);
                            }
                        }
                        catch (HyracksDataException e) {
                            t = e.getCause();
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleOperation(ILSMIOOperation operation) throws HyracksDataException {
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOpertionType.MERGE) {
            this.executor.submit(operation);
        } else {
            String id = operation.getIndexUniqueIdentifier();
            ExecutorService executorService = this.executor;
            synchronized (executorService) {
                if (this.runningFlushOperations.containsKey(id)) {
                    if (this.waitingFlushOperations.containsKey(id)) {
                        this.waitingFlushOperations.get(id).offer(operation);
                    } else {
                        PriorityQueue<ILSMIOOperation> q = new PriorityQueue<ILSMIOOperation>();
                        q.offer(operation);
                        this.waitingFlushOperations.put(id, q);
                    }
                } else {
                    this.runningFlushOperations.put(id, operation);
                    this.executor.submit(operation);
                }
            }
        }
    }
}

