/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.frames;

import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterReference;

public class LSMComponentFilterReference
implements ILSMComponentFilterReference {
    private static final int MIN_SET_INDICATOR_OFFSET = 0;
    private static final int MAX_SET_INDICATOR_OFFSET = 1;
    private final ArrayBackedValueStorage min;
    private final ArrayBackedValueStorage max;
    private ArrayBackedValueStorage binaryFilter;
    private final ITreeIndexTupleWriter tupleWriter;
    private ITreeIndexTupleReference minTuple;
    private ITreeIndexTupleReference maxTuple;

    public LSMComponentFilterReference(ITreeIndexTupleWriter tupleWriter) {
        this.tupleWriter = tupleWriter;
        this.min = new ArrayBackedValueStorage();
        this.max = new ArrayBackedValueStorage();
        this.binaryFilter = new ArrayBackedValueStorage();
        this.minTuple = tupleWriter.createTupleReference();
        this.maxTuple = tupleWriter.createTupleReference();
    }

    @Override
    public void writeMinTuple(ITupleReference tuple) {
        this.binaryFilter.reset();
        this.min.reset();
        this.min.setSize(this.tupleWriter.bytesRequired(tuple));
        this.tupleWriter.writeTuple(tuple, this.min.getByteArray(), 0);
    }

    @Override
    public void writeMaxTuple(ITupleReference tuple) {
        this.binaryFilter.reset();
        this.max.reset();
        this.max.setSize(this.tupleWriter.bytesRequired(tuple));
        this.tupleWriter.writeTuple(tuple, this.max.getByteArray(), 0);
    }

    @Override
    public boolean isMinTupleSet() {
        return this.min.getLength() > 0;
    }

    @Override
    public boolean isMaxTupleSet() {
        return this.max.getLength() > 0;
    }

    @Override
    public ITupleReference getMinTuple() {
        this.minTuple.resetByTupleOffset(this.min.getByteArray(), 0);
        return this.minTuple;
    }

    @Override
    public ITupleReference getMaxTuple() {
        this.maxTuple.resetByTupleOffset(this.max.getByteArray(), 0);
        return this.maxTuple;
    }

    public byte[] getByteArray() {
        if (this.binaryFilter.getLength() == 0) {
            int binarySize = 2;
            if (this.min.getLength() > 0) {
                binarySize += 4 + this.min.getLength();
            }
            if (this.max.getLength() > 0) {
                binarySize += 4 + this.max.getLength();
            }
            this.binaryFilter.setSize(binarySize);
            byte[] buf = this.binaryFilter.getByteArray();
            BooleanPointable.setBoolean((byte[])buf, (int)0, (this.min.getLength() == 0 ? 1 : 0) != 0);
            BooleanPointable.setBoolean((byte[])buf, (int)1, (this.max.getLength() == 0 ? 1 : 0) != 0);
            int offset = 2;
            if (this.min.getLength() > 0) {
                IntegerPointable.setInteger((byte[])buf, (int)offset, (int)this.min.getLength());
                System.arraycopy(this.min.getByteArray(), 0, buf, offset += 4, this.min.getLength());
            }
            if (this.max.getLength() > 0) {
                IntegerPointable.setInteger((byte[])buf, (int)offset, (int)this.max.getLength());
                System.arraycopy(this.max.getByteArray(), 0, buf, offset += 4, this.max.getLength());
            }
        }
        return this.binaryFilter.getByteArray();
    }

    public int getStartOffset() {
        return 0;
    }

    public int getLength() {
        return this.binaryFilter.getLength();
    }

    @Override
    public void reset() {
        this.min.reset();
        this.max.reset();
        this.binaryFilter.reset();
    }

    public void set(byte[] bytes, int start, int length) {
        boolean isMinSet = BooleanPointable.getBoolean((byte[])bytes, (int)(0 + start));
        boolean isMaxSet = BooleanPointable.getBoolean((byte[])bytes, (int)(1 + start));
        int srcOffset = start + 2;
        if (isMinSet) {
            this.min.setSize(IntegerPointable.getInteger((byte[])bytes, (int)srcOffset));
            System.arraycopy(bytes, srcOffset += 4, this.min.getByteArray(), 0, this.min.getLength());
            srcOffset += this.min.getLength();
        }
        if (isMaxSet) {
            this.max.setSize(IntegerPointable.getInteger((byte[])bytes, (int)srcOffset));
            System.arraycopy(bytes, srcOffset += 4, this.max.getByteArray(), 0, this.max.getLength());
        }
        this.binaryFilter.reset();
    }

    public void set(IValueReference pointer) {
        this.set(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }
}

