/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tokenizer;

import org.apache.asterix.fuzzyjoin.IntArray;
import org.apache.asterix.fuzzyjoin.tokenizer.Token;
import org.apache.asterix.fuzzyjoin.tokenizer.TokenizerBuffered;
import org.apache.asterix.fuzzyjoin.tokenizer.TokenizerBufferedFactory;

public class WordTokenizerBuffered
implements TokenizerBuffered {
    private final StringBuilder buffer;
    private int index;
    private final Token token;
    private final IntArray tokensStart;
    private final IntArray tokensLength;

    public WordTokenizerBuffered(StringBuilder buffer) {
        this.buffer = buffer;
        this.token = new Token();
        this.tokensStart = new IntArray();
        this.tokensLength = new IntArray();
        this.reset();
    }

    @Override
    public void advance() {
        while (this.index < this.buffer.length() && TokenizerBufferedFactory.isSeparator(this.buffer.charAt(this.index))) {
            ++this.index;
        }
        int start = this.index;
        while (this.index < this.buffer.length() && !TokenizerBufferedFactory.isSeparator(this.buffer.charAt(this.index))) {
            this.buffer.setCharAt(this.index, Character.toLowerCase(this.buffer.charAt(this.index)));
            ++this.index;
        }
        int length = this.index - start;
        int count = 1;
        if (length > 0) {
            block2: for (int i = 0; i < this.tokensStart.length(); ++i) {
                if (length != this.tokensLength.get(i)) continue;
                int tokenStart = this.tokensStart.get(i);
                ++count;
                for (int j = 0; j < length; ++j) {
                    if (this.buffer.charAt(start + j) == this.buffer.charAt(tokenStart + j)) continue;
                    --count;
                    continue block2;
                }
            }
            this.tokensStart.add(start);
            this.tokensLength.add(length);
        }
        this.token.set(this.buffer, start, length, count);
    }

    @Override
    public boolean end() {
        return this.token.length() <= 0;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.tokensStart.reset();
        this.tokensLength.reset();
        this.advance();
    }
}

