/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.dataflow;

import java.io.DataOutput;
import java.io.File;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.hdfs.api.ITupleWriter;
import org.apache.hyracks.hdfs.api.ITupleWriterFactory;
import org.apache.hyracks.hdfs.dataflow.ConfFactory;

public class HDFSWriteOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private ConfFactory confFactory;
    private ITupleWriterFactory tupleWriterFactory;

    public HDFSWriteOperatorDescriptor(JobSpecification spec, JobConf conf, ITupleWriterFactory tupleWriterFactory) throws HyracksException {
        super((IOperatorDescriptorRegistry)spec, 1, 0);
        this.confFactory = new ConfFactory(conf);
        this.tupleWriterFactory = tupleWriterFactory;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private FSDataOutputStream dos;
            private RecordDescriptor inputRd;
            private FrameTupleAccessor accessor;
            private FrameTupleReference tuple;
            private ITupleWriter tupleWriter;
            private ClassLoader ctxCL;
            {
                this.inputRd = recordDescProvider.getInputRecordDescriptor(HDFSWriteOperatorDescriptor.this.getActivityId(), 0);
                this.accessor = new FrameTupleAccessor(this.inputRd);
                this.tuple = new FrameTupleReference();
            }

            public void open() throws HyracksDataException {
                this.ctxCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                JobConf conf = HDFSWriteOperatorDescriptor.this.confFactory.getConf();
                String outputDirPath = FileOutputFormat.getOutputPath((JobConf)conf).toString();
                String fileName = outputDirPath + File.separator + "part-" + partition;
                this.tupleWriter = HDFSWriteOperatorDescriptor.this.tupleWriterFactory.getTupleWriter(ctx, partition, nPartitions);
                try {
                    FileSystem dfs = FileSystem.get((Configuration)conf);
                    this.dos = dfs.create(new Path(fileName), true);
                    this.tupleWriter.open((DataOutput)this.dos);
                }
                catch (Exception e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.accessor.reset(buffer);
                int tupleCount = this.accessor.getTupleCount();
                for (int i = 0; i < tupleCount; ++i) {
                    this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                    this.tupleWriter.write((DataOutput)this.dos, (ITupleReference)this.tuple);
                }
            }

            public void fail() throws HyracksDataException {
            }

            public void close() throws HyracksDataException {
                try {
                    this.tupleWriter.close((DataOutput)this.dos);
                    this.dos.close();
                }
                catch (Exception e) {
                    throw new HyracksDataException((Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(this.ctxCL);
                }
            }
        };
    }
}

