/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;

public final class BooleanPointable
extends AbstractPointable
implements IHashable,
IComparable {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 1;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new BooleanPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public static boolean getBoolean(byte[] bytes, int start) {
        return bytes[start] != 0;
    }

    public static void setBoolean(byte[] bytes, int start, boolean value) {
        bytes[start] = (byte)(value ? 1 : 0);
    }

    public boolean getBoolean() {
        return BooleanPointable.getBoolean(this.bytes, this.start);
    }

    public void setBoolean(boolean value) {
        BooleanPointable.setBoolean(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        boolean ob;
        boolean b = this.getBoolean();
        return b == (ob = BooleanPointable.getBoolean(bytes, start)) ? 0 : (b ? 1 : -1);
    }

    @Override
    public int hash() {
        return this.getBoolean() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }
}

