/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.common.transactions.ILogMarkerCallback;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.utils.ComponentMetadataUtil;

public class PrimaryIndexLogMarkerCallback
implements ILogMarkerCallback {
    private final LongPointable pointable = LongPointable.FACTORY.createPointable();
    private final ILSMIndex index;

    public PrimaryIndexLogMarkerCallback(ILSMIndex index) throws HyracksDataException {
        this.index = index;
    }

    @Override
    public void before(ByteBuffer buffer) {
        buffer.putLong(this.getLsn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLsn() {
        long lsn;
        try {
            lsn = ComponentMetadataUtil.getLong((IComponentMetadata)this.index.getCurrentMemoryComponent().getMetadata(), (IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (long)-1L);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
        if (lsn == -1L) {
            ILSMOperationTracker iLSMOperationTracker = this.index.getOperationTracker();
            synchronized (iLSMOperationTracker) {
                lsn = this.lsnFromImmutableMemoryComponents();
                if (lsn == -1L) {
                    lsn = this.lsnFromDiskComponents();
                }
            }
        }
        return lsn;
    }

    private long lsnFromDiskComponents() {
        List diskComponents = this.index.getImmutableComponents();
        for (ILSMDiskComponent c : diskComponents) {
            try {
                long lsn = ComponentMetadataUtil.getLong((IComponentMetadata)c.getMetadata(), (IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (long)-1L);
                if (lsn == -1L) continue;
                return lsn;
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException("Unable to read metadata page. Disk Error?", e);
            }
        }
        return -1L;
    }

    private long lsnFromImmutableMemoryComponents() {
        List memComponents = this.index.getMemoryComponents();
        int numOtherMemComponents = memComponents.size() - 1;
        int next = this.index.getCurrentMemoryComponentIndex();
        long lsn = -1L;
        for (int i = 0; i < numOtherMemComponents; ++i) {
            ILSMMemoryComponent c;
            if (--next < 0) {
                next = memComponents.size() - 1;
            }
            if (!(c = (ILSMMemoryComponent)this.index.getMemoryComponents().get(next)).isReadable()) continue;
            try {
                lsn = ComponentMetadataUtil.getLong((IComponentMetadata)c.getMetadata(), (IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (long)-1L);
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException(e);
            }
            if (lsn == -1L) continue;
            return lsn;
        }
        return lsn;
    }

    @Override
    public void after(long lsn) {
        this.pointable.setLong(lsn);
        this.index.getCurrentMemoryComponent().getMetadata().put((IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (IValueReference)this.pointable);
    }

    public ILSMIndex getIndex() {
        return this.index;
    }
}

