/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.replication;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.replication.ChainedDeclusteringReplicationStrategy;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.MetadataOnlyReplicationStrategy;
import org.apache.asterix.common.replication.NoReplicationStrategy;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ReplicationStrategyFactory {
    private static final Map<String, Class<? extends IReplicationStrategy>> BUILT_IN_REPLICATION_STRATEGY = new HashMap<String, Class<? extends IReplicationStrategy>>();

    private ReplicationStrategyFactory() {
        throw new AssertionError();
    }

    public static IReplicationStrategy create(Cluster cluster) throws HyracksDataException {
        boolean highAvailabilityEnabled;
        boolean bl = highAvailabilityEnabled = cluster.getHighAvailability() != null && cluster.getHighAvailability().getEnabled() != null && Boolean.valueOf(cluster.getHighAvailability().getEnabled()) != false;
        if (!highAvailabilityEnabled || cluster.getHighAvailability().getDataReplication() == null || cluster.getHighAvailability().getDataReplication().getStrategy() == null) {
            return new NoReplicationStrategy();
        }
        String strategyName = cluster.getHighAvailability().getDataReplication().getStrategy().toLowerCase();
        if (!BUILT_IN_REPLICATION_STRATEGY.containsKey(strategyName)) {
            throw new RuntimeDataException(4005, new Serializable[]{String.format("%s. Available strategies: %s", strategyName, BUILT_IN_REPLICATION_STRATEGY.keySet().toString())});
        }
        Class<? extends IReplicationStrategy> clazz = BUILT_IN_REPLICATION_STRATEGY.get(strategyName);
        try {
            return clazz.newInstance().from(cluster);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(100, e, new Serializable[]{clazz.getName()});
        }
    }

    static {
        BUILT_IN_REPLICATION_STRATEGY.put("no_replication", NoReplicationStrategy.class);
        BUILT_IN_REPLICATION_STRATEGY.put("chained_declustering", ChainedDeclusteringReplicationStrategy.class);
        BUILT_IN_REPLICATION_STRATEGY.put("metadata_only", MetadataOnlyReplicationStrategy.class);
    }
}

