/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;

public class LSMRTreeIOOperationCallback
extends AbstractLSMIOOperationCallback {
    public void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        if (newComponent != null) {
            LSMRTreeDiskComponent rtreeComponent = (LSMRTreeDiskComponent)newComponent;
            this.putLSNIntoMetadata((ILSMDiskComponent)rtreeComponent, oldComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents == null) {
            LSMRTreeIOOperationCallback lSMRTreeIOOperationCallback = this;
            synchronized (lSMRTreeIOOperationCallback) {
                long lsn = this.mutableLastLSNs[this.readIndex];
                return lsn;
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            LSMRTreeDiskComponent rtreeComponent = (LSMRTreeDiskComponent)iLSMComponent;
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN((ITreeIndex)rtreeComponent.getRTree()), maxLSN);
        }
        return maxLSN;
    }

    @Override
    public long getComponentFileLSNOffset(ILSMDiskComponent diskComponent, String diskComponentFilePath) throws HyracksDataException {
        if (diskComponentFilePath.endsWith("r")) {
            LSMRTreeDiskComponent rtreeComponent = (LSMRTreeDiskComponent)diskComponent;
            IMetadataPageManager metadataPageManager = (IMetadataPageManager)rtreeComponent.getRTree().getPageManager();
            return metadataPageManager.getFileOffset(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY);
        }
        return -1L;
    }
}

