/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;

public abstract class AbstractLSMIOOperationCallback
implements ILSMIOOperationCallback {
    public static final MutableArrayValueReference LSN_KEY = new MutableArrayValueReference("LSN".getBytes());
    public static final long INVALID = -1L;
    protected long[] firstLSNs;
    protected boolean[] flushRequested;
    protected long[] mutableLastLSNs;
    protected int readIndex;
    protected int writeIndex;

    public void setNumOfMutableComponents(int count) {
        this.mutableLastLSNs = new long[count];
        this.firstLSNs = new long[count];
        this.flushRequested = new boolean[count];
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeOperation(LSMOperationType opType) {
        if (opType == LSMOperationType.FLUSH) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.writeIndex] = true;
                this.writeIndex = (this.writeIndex + 1) % this.mutableLastLSNs.length;
                if (this.writeIndex != this.readIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterFinalize(LSMOperationType opType, ILSMDiskComponent newComponent) {
        if (opType == LSMOperationType.FLUSH && newComponent != null) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.readIndex] = false;
                if (this.readIndex == this.writeIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
                this.readIndex = (this.readIndex + 1) % this.mutableLastLSNs.length;
            }
        }
    }

    public abstract long getComponentLSN(List<? extends ILSMComponent> var1) throws HyracksDataException;

    public void putLSNIntoMetadata(ILSMDiskComponent index, List<ILSMComponent> oldComponents) throws HyracksDataException {
        index.getMetadata().put((IValueReference)LSN_KEY, (IValueReference)LongPointable.FACTORY.createPointable(this.getComponentLSN(oldComponents)));
    }

    public static long getTreeIndexLSN(ITreeIndex treeIndex) throws HyracksDataException {
        LongPointable pointable = new LongPointable();
        IMetadataPageManager metadataPageManager = (IMetadataPageManager)treeIndex.getPageManager();
        metadataPageManager.get(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY, (IPointable)pointable);
        return pointable.getLength() == 0 ? -1L : pointable.longValue();
    }

    public void updateLastLSN(long lastLSN) {
        this.mutableLastLSNs[this.writeIndex] = lastLSN;
    }

    public void setFirstLSN(long firstLSN) {
        this.firstLSNs[this.writeIndex] = firstLSN;
    }

    public synchronized long getFirstLSN() {
        return this.firstLSNs[this.readIndex];
    }

    public synchronized boolean hasPendingFlush() {
        for (int i = 0; i < this.flushRequested.length; ++i) {
            if (!this.flushRequested[i]) continue;
            return true;
        }
        return false;
    }

    public abstract long getComponentFileLSNOffset(ILSMDiskComponent var1, String var2) throws HyracksDataException;
}

