/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.DatasetResource;
import org.apache.asterix.common.context.DatasetVirtualBufferCaches;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.Resource;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IResourceMemoryManager;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class DatasetLifecycleManager
implements IDatasetLifecycleManager,
ILifeCycleComponent {
    private final Map<Integer, DatasetResource> datasets = new ConcurrentHashMap<Integer, DatasetResource>();
    private final StorageProperties storageProperties;
    private final ILocalResourceRepository resourceRepository;
    private final int firstAvilableUserDatasetID;
    private final long capacity;
    private long used;
    private final ILogManager logManager;
    private final LogRecord logRecord;
    private final int numPartitions;
    private volatile boolean stopped = false;

    public DatasetLifecycleManager(StorageProperties storageProperties, ILocalResourceRepository resourceRepository, int firstAvilableUserDatasetID, ILogManager logManager, int numPartitions) {
        this.logManager = logManager;
        this.storageProperties = storageProperties;
        this.resourceRepository = resourceRepository;
        this.firstAvilableUserDatasetID = firstAvilableUserDatasetID;
        this.numPartitions = numPartitions;
        this.capacity = storageProperties.getMemoryComponentGlobalBudget();
        this.used = 0L;
        this.logRecord = new LogRecord();
    }

    public synchronized ILSMIndex get(String resourcePath) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int datasetID = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        return this.getIndex(datasetID, resourceID);
    }

    public synchronized ILSMIndex getIndex(int datasetID, long resourceID) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        DatasetResource datasetResource = this.datasets.get(datasetID);
        if (datasetResource == null) {
            return null;
        }
        return datasetResource.getIndex(resourceID);
    }

    public synchronized void register(String resourcePath, IIndex index) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource datasetResource = this.datasets.get(did);
        if (datasetResource == null) {
            datasetResource = this.getDatasetLifecycle(did);
        }
        datasetResource.register(resourceID, index);
    }

    public int getDIDfromResourcePath(String resourcePath) throws HyracksDataException {
        LocalResource lr = this.resourceRepository.get(resourcePath);
        if (lr == null) {
            return -1;
        }
        return ((Resource)lr.getResource()).datasetId();
    }

    public long getResourceIDfromResourcePath(String resourcePath) throws HyracksDataException {
        LocalResource lr = this.resourceRepository.get(resourcePath);
        if (lr == null) {
            return -1L;
        }
        return lr.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String resourcePath) throws HyracksDataException {
        DatasetInfo dsInfo;
        IndexInfo iInfo;
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource dsr = this.datasets.get(did);
        IndexInfo indexInfo = iInfo = dsr == null ? null : dsr.getIndexInfo(resourceID);
        if (dsr == null || iInfo == null) {
            throw new HyracksDataException("Index with resource ID " + resourceID + " does not exist.");
        }
        PrimaryIndexOperationTracker opTracker = dsr.getOpTracker();
        if (iInfo.getReferenceCount() != 0 || opTracker != null && opTracker.getNumActiveOperations() != 0) {
            throw new HyracksDataException("Cannot remove index while it is open. (Dataset reference count = " + iInfo.getReferenceCount() + ", Operation tracker number of active operations = " + opTracker.getNumActiveOperations() + ")");
        }
        DatasetInfo datasetInfo = dsInfo = dsr.getDatasetInfo();
        synchronized (datasetInfo) {
            while (dsInfo.getNumActiveIOOps() > 0) {
                try {
                    dsInfo.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
        if (iInfo.isOpen()) {
            ILSMOperationTracker indexOpTracker;
            ILSMOperationTracker iLSMOperationTracker = indexOpTracker = iInfo.getIndex().getOperationTracker();
            synchronized (iLSMOperationTracker) {
                iInfo.getIndex().deactivate(false);
            }
        }
        dsInfo.getIndexes().remove(resourceID);
        if (dsInfo.getReferenceCount() == 0 && dsInfo.isOpen() && dsInfo.getIndexes().isEmpty() && !dsInfo.isExternal()) {
            this.removeDatasetFromCache(dsInfo.getDatasetID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(String resourcePath) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource dsr = this.datasets.get(did);
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        if (dsInfo == null || !dsInfo.isRegistered()) {
            throw new HyracksDataException("Failed to open index with resource ID " + resourceID + " since it does not exist.");
        }
        IndexInfo iInfo = dsInfo.getIndexes().get(resourceID);
        if (iInfo == null) {
            throw new HyracksDataException("Failed to open index with resource ID " + resourceID + " since it does not exist.");
        }
        dsr.open(true);
        dsr.touch();
        if (!iInfo.isOpen()) {
            ILSMOperationTracker opTracker;
            ILSMOperationTracker iLSMOperationTracker = opTracker = iInfo.getIndex().getOperationTracker();
            synchronized (iLSMOperationTracker) {
                iInfo.getIndex().activate();
            }
            iInfo.setOpen(true);
        }
        iInfo.touch();
    }

    private boolean evictCandidateDataset() throws HyracksDataException {
        ArrayList<DatasetResource> datasetsResources = new ArrayList<DatasetResource>(this.datasets.values());
        Collections.sort(datasetsResources);
        for (DatasetResource dsr : datasetsResources) {
            PrimaryIndexOperationTracker opTracker = dsr.getOpTracker();
            if (opTracker == null || opTracker.getNumActiveOperations() != 0 || dsr.getDatasetInfo().getReferenceCount() != 0 || !dsr.getDatasetInfo().isOpen() || dsr.getDatasetInfo().getDatasetID() < this.getFirstAvilableUserDatasetID()) continue;
            this.closeDataset(dsr.getDatasetInfo());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushAndWaitForIO(DatasetInfo dsInfo, IndexInfo iInfo) throws HyracksDataException {
        if (iInfo.isOpen()) {
            ILSMIndexAccessor accessor = iInfo.getIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFlush(iInfo.getIndex().getIOOperationCallback());
        }
        DatasetInfo datasetInfo = dsInfo;
        synchronized (datasetInfo) {
            while (dsInfo.getNumActiveIOOps() > 0) {
                try {
                    dsInfo.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetResource getDatasetLifecycle(int did) {
        DatasetResource dsr = this.datasets.get(did);
        if (dsr != null) {
            return dsr;
        }
        Map<Integer, DatasetResource> map = this.datasets;
        synchronized (map) {
            dsr = this.datasets.get(did);
            if (dsr == null) {
                DatasetInfo dsInfo = new DatasetInfo(did);
                PrimaryIndexOperationTracker opTracker = new PrimaryIndexOperationTracker(did, this.logManager, dsInfo);
                DatasetVirtualBufferCaches vbcs = new DatasetVirtualBufferCaches(did, this.storageProperties, this.getFirstAvilableUserDatasetID(), this.getNumPartitions());
                dsr = new DatasetResource(dsInfo, opTracker, vbcs);
                this.datasets.put(did, dsr);
            }
            return dsr;
        }
    }

    @Override
    public DatasetInfo getDatasetInfo(int datasetID) {
        return this.getDatasetLifecycle(datasetID).getDatasetInfo();
    }

    public synchronized void close(String resourcePath) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource dsr = this.datasets.get(did);
        if (dsr == null) {
            throw new HyracksDataException("No index found with resourceID " + resourceID);
        }
        IndexInfo iInfo = dsr.getIndexInfo(resourceID);
        if (iInfo == null) {
            throw new HyracksDataException("No index found with resourceID " + resourceID);
        }
        iInfo.untouch();
        dsr.untouch();
    }

    public synchronized List<IIndex> getOpenResources() {
        List<IndexInfo> openIndexesInfo = this.getOpenIndexesInfo();
        ArrayList<IIndex> openIndexes = new ArrayList<IIndex>();
        for (IndexInfo iInfo : openIndexesInfo) {
            openIndexes.add((IIndex)iInfo.getIndex());
        }
        return openIndexes;
    }

    @Override
    public synchronized List<IndexInfo> getOpenIndexesInfo() {
        ArrayList<IndexInfo> openIndexesInfo = new ArrayList<IndexInfo>();
        for (DatasetResource dsr : this.datasets.values()) {
            for (IndexInfo iInfo : dsr.getIndexes().values()) {
                if (!iInfo.isOpen()) continue;
                openIndexesInfo.add(iInfo);
            }
        }
        return openIndexesInfo;
    }

    private DatasetVirtualBufferCaches getVirtualBufferCaches(int datasetID) {
        return this.getDatasetLifecycle(datasetID).getVirtualBufferCaches();
    }

    @Override
    public List<IVirtualBufferCache> getVirtualBufferCaches(int datasetID, int ioDeviceNum) {
        DatasetVirtualBufferCaches dvbcs = this.getVirtualBufferCaches(datasetID);
        return dvbcs.getVirtualBufferCaches((IResourceMemoryManager)this, ioDeviceNum);
    }

    private void removeDatasetFromCache(int datasetID) throws HyracksDataException {
        this.deallocateDatasetMemory(datasetID);
        this.datasets.remove(datasetID);
    }

    @Override
    public PrimaryIndexOperationTracker getOperationTracker(int datasetID) {
        return this.datasets.get(datasetID).getOpTracker();
    }

    private void validateDatasetLifecycleManagerState() throws HyracksDataException {
        if (this.stopped) {
            throw new HyracksDataException(DatasetLifecycleManager.class.getSimpleName() + " was stopped.");
        }
    }

    public synchronized void start() {
        this.used = 0L;
    }

    @Override
    public synchronized void flushAllDatasets() throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            this.flushDatasetOpenIndexes(dsr.getDatasetInfo(), false);
        }
    }

    @Override
    public synchronized void flushDataset(int datasetId, boolean asyncFlush) throws HyracksDataException {
        DatasetResource dsr = this.datasets.get(datasetId);
        if (dsr != null) {
            this.flushDatasetOpenIndexes(dsr.getDatasetInfo(), asyncFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void scheduleAsyncFlushForLaggingDatasets(long targetLSN) throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            PrimaryIndexOperationTracker opTracker;
            PrimaryIndexOperationTracker primaryIndexOperationTracker = opTracker = dsr.getOpTracker();
            synchronized (primaryIndexOperationTracker) {
                for (IndexInfo iInfo : dsr.getIndexes().values()) {
                    long firstLSN;
                    AbstractLSMIOOperationCallback ioCallback = (AbstractLSMIOOperationCallback)iInfo.getIndex().getIOOperationCallback();
                    if (((AbstractLSMIndex)iInfo.getIndex()).isCurrentMutableComponentEmpty() || ioCallback.hasPendingFlush() || opTracker.isFlushLogCreated() || opTracker.isFlushOnExit() || (firstLSN = ioCallback.getFirstLSN()) >= targetLSN) continue;
                    opTracker.setFlushOnExit(true);
                    if (opTracker.getNumActiveOperations() != 0) break;
                    opTracker.flushIfRequested();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDatasetOpenIndexes(DatasetInfo dsInfo, boolean asyncFlush) throws HyracksDataException {
        if (!dsInfo.isExternal() && dsInfo.isDurable()) {
            Iterator<IndexInfo> iterator = this.logRecord;
            synchronized (iterator) {
                TransactionUtil.formFlushLogRecord(this.logRecord, dsInfo.getDatasetID(), null, this.logManager.getNodeId(), dsInfo.getIndexes().size());
                try {
                    this.logManager.log(this.logRecord);
                }
                catch (ACIDException e) {
                    throw new HyracksDataException("could not write flush log while closing dataset", (Throwable)e);
                }
                try {
                    this.logRecord.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
                AbstractLSMIOOperationCallback ioOpCallback = (AbstractLSMIOOperationCallback)iInfo.getIndex().getIOOperationCallback();
                ioOpCallback.updateLastLSN(this.logRecord.getLSN());
            }
        }
        if (asyncFlush) {
            for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
                ILSMIndexAccessor accessor = iInfo.getIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                accessor.scheduleFlush(iInfo.getIndex().getIOOperationCallback());
            }
        } else {
            for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
                DatasetLifecycleManager.flushAndWaitForIO(dsInfo, iInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataset(DatasetInfo dsInfo) throws HyracksDataException {
        DatasetInfo datasetInfo = dsInfo;
        synchronized (datasetInfo) {
            while (dsInfo.getNumActiveIOOps() > 0) {
                try {
                    dsInfo.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
        try {
            this.flushDatasetOpenIndexes(dsInfo, false);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
            ILSMOperationTracker opTracker;
            if (!iInfo.isOpen()) continue;
            ILSMOperationTracker iLSMOperationTracker = opTracker = iInfo.getIndex().getOperationTracker();
            synchronized (iLSMOperationTracker) {
                iInfo.getIndex().deactivate(false);
            }
            iInfo.setOpen(false);
        }
        this.removeDatasetFromCache(dsInfo.getDatasetID());
        dsInfo.setOpen(false);
    }

    @Override
    public synchronized void closeAllDatasets() throws HyracksDataException {
        ArrayList<DatasetResource> openDatasets = new ArrayList<DatasetResource>(this.datasets.values());
        for (DatasetResource dsr : openDatasets) {
            this.closeDataset(dsr.getDatasetInfo());
        }
    }

    @Override
    public synchronized void closeUserDatasets() throws HyracksDataException {
        ArrayList<DatasetResource> openDatasets = new ArrayList<DatasetResource>(this.datasets.values());
        for (DatasetResource dsr : openDatasets) {
            if (dsr.getDatasetID() < this.getFirstAvilableUserDatasetID()) continue;
            this.closeDataset(dsr.getDatasetInfo());
        }
    }

    public synchronized void stop(boolean dumpState, OutputStream outputStream) throws IOException {
        if (this.stopped) {
            return;
        }
        if (dumpState) {
            this.dumpState(outputStream);
        }
        this.closeAllDatasets();
        this.datasets.clear();
        this.stopped = true;
    }

    public void dumpState(OutputStream outputStream) throws IOException {
        DatasetInfo dsInfo;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Memory budget = %d\n", this.capacity));
        sb.append(String.format("Memory used = %d\n", this.used));
        sb.append("\n");
        String dsHeaderFormat = "%-10s %-6s %-16s %-12s\n";
        String dsFormat = "%-10d %-6b %-16d %-12d\n";
        String idxHeaderFormat = "%-10s %-11s %-6s %-16s %-6s\n";
        String idxFormat = "%-10d %-11d %-6b %-16d %-6s\n";
        sb.append("[Datasets]\n");
        sb.append(String.format(dsHeaderFormat, "DatasetID", "Open", "Reference Count", "Last Access"));
        for (DatasetResource dsr : this.datasets.values()) {
            dsInfo = dsr.getDatasetInfo();
            sb.append(String.format(dsFormat, dsInfo.getDatasetID(), dsInfo.isOpen(), dsInfo.getReferenceCount(), dsInfo.getLastAccess()));
        }
        sb.append("\n");
        sb.append("[Indexes]\n");
        sb.append(String.format(idxHeaderFormat, "DatasetID", "ResourceID", "Open", "Reference Count", "Index"));
        for (DatasetResource dsr : this.datasets.values()) {
            dsInfo = dsr.getDatasetInfo();
            for (Map.Entry<Long, IndexInfo> entry : dsInfo.getIndexes().entrySet()) {
                IndexInfo iInfo = entry.getValue();
                sb.append(String.format(idxFormat, dsInfo.getDatasetID(), entry.getKey(), iInfo.isOpen(), iInfo.getReferenceCount(), iInfo.getIndex()));
            }
        }
        outputStream.write(sb.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deallocateDatasetMemory(int datasetId) throws HyracksDataException {
        DatasetResource dsr = this.datasets.get(datasetId);
        if (dsr == null) {
            throw new HyracksDataException("Failed to allocate memory for dataset with ID " + datasetId + " since it is not open.");
        }
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        if (dsInfo == null) {
            throw new HyracksDataException("Failed to deallocate memory for dataset with ID " + datasetId + " since it is not open.");
        }
        DatasetInfo datasetInfo = dsInfo;
        synchronized (datasetInfo) {
            if (dsInfo.isOpen() && dsInfo.isMemoryAllocated()) {
                this.used -= this.getVirtualBufferCaches(dsInfo.getDatasetID()).getTotalSize();
                dsInfo.setMemoryAllocated(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void allocateMemory(String resourcePath) throws HyracksDataException {
        DatasetInfo dsInfo;
        int datasetId = Integer.parseInt(resourcePath);
        DatasetResource dsr = this.datasets.get(datasetId);
        if (dsr == null) {
            throw new HyracksDataException("Failed to allocate memory for dataset with ID " + datasetId + " since it is not open.");
        }
        DatasetInfo datasetInfo = dsInfo = dsr.getDatasetInfo();
        synchronized (datasetInfo) {
            if (!dsInfo.isMemoryAllocated() && !dsInfo.isExternal()) {
                long additionalSize = this.getVirtualBufferCaches(dsInfo.getDatasetID()).getTotalSize();
                while (this.used + additionalSize > this.capacity) {
                    if (this.evictCandidateDataset()) continue;
                    throw new HyracksDataException("Cannot allocate dataset " + dsInfo.getDatasetID() + " memory since memory budget would be exceeded.");
                }
                this.used += additionalSize;
                dsInfo.setMemoryAllocated(true);
            }
        }
    }

    public int getFirstAvilableUserDatasetID() {
        return this.firstAvilableUserDatasetID;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public void flushDataset(IReplicationStrategy replicationStrategy) throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            if (!replicationStrategy.isMatch(dsr.getDatasetID())) continue;
            this.flushDatasetOpenIndexes(dsr.getDatasetInfo(), false);
        }
    }
}

