/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.MutableLong;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;

public class TransactionContext
implements ITransactionContext,
Serializable {
    private static final long serialVersionUID = -6105616785783310111L;
    private final JobId jobId;
    private final AtomicLong firstLSN;
    private final AtomicLong lastLSN;
    private final AtomicInteger txnState;
    private boolean isTimeout;
    private final AtomicBoolean isWriteTxn;
    private boolean isMetadataTxn;
    private final Map<MutableLong, AbstractLSMIOOperationCallback> indexMap;
    private ILSMIndex primaryIndex;
    private AbstractOperationCallback primaryIndexCallback;
    private PrimaryIndexOperationTracker primaryIndexOpTracker;
    private final MutableLong tempResourceIdForRegister;
    private final LogRecord logRecord;
    private final AtomicInteger transactorNumActiveOperations;

    public TransactionContext(JobId jobId) throws ACIDException {
        this.jobId = jobId;
        this.firstLSN = new AtomicLong(-1L);
        this.lastLSN = new AtomicLong(-1L);
        this.txnState = new AtomicInteger(0);
        this.isTimeout = false;
        this.isWriteTxn = new AtomicBoolean(false);
        this.isMetadataTxn = false;
        this.indexMap = new HashMap<MutableLong, AbstractLSMIOOperationCallback>();
        this.primaryIndex = null;
        this.tempResourceIdForRegister = new MutableLong();
        this.logRecord = new LogRecord();
        this.transactorNumActiveOperations = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndexAndCallback(long resourceId, ILSMIndex index, AbstractOperationCallback callback, boolean isPrimaryIndex) {
        Map<MutableLong, AbstractLSMIOOperationCallback> map = this.indexMap;
        synchronized (map) {
            if (isPrimaryIndex && this.primaryIndex == null) {
                this.primaryIndex = index;
                this.primaryIndexCallback = callback;
                this.primaryIndexOpTracker = (PrimaryIndexOperationTracker)index.getOperationTracker();
            }
            this.tempResourceIdForRegister.set(resourceId);
            if (!this.indexMap.containsKey(this.tempResourceIdForRegister)) {
                this.indexMap.put(new MutableLong(resourceId), (AbstractLSMIOOperationCallback)index.getIOOperationCallback());
            }
        }
    }

    public void setLastLSN(long LSN) {
        this.firstLSN.compareAndSet(-1L, LSN);
        this.lastLSN.set(Math.max(this.lastLSN.get(), LSN));
    }

    public void notifyOptracker(boolean isJobLevelCommit) {
        try {
            if (isJobLevelCommit && this.isMetadataTxn) {
                this.primaryIndexOpTracker.exclusiveJobCommitted();
            } else if (!isJobLevelCommit) {
                this.primaryIndexOpTracker.completeOperation(null, LSMOperationType.MODIFICATION, null, (IModificationOperationCallback)this.primaryIndexCallback);
            }
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setWriteTxn(boolean isWriteTxn) {
        this.isWriteTxn.set(isWriteTxn);
    }

    public boolean isWriteTxn() {
        return this.isWriteTxn.get();
    }

    public long getFirstLSN() {
        return this.firstLSN.get();
    }

    public long getLastLSN() {
        return this.lastLSN.get();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public void setTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public void setTxnState(int txnState) {
        this.txnState.set(txnState);
    }

    public int getTxnState() {
        return this.txnState.get();
    }

    public int hashCode() {
        return this.jobId.getId();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public void setMetadataTransaction(boolean isMetadataTxn) {
        this.isMetadataTxn = isMetadataTxn;
    }

    public boolean isMetadataTransaction() {
        return this.isMetadataTxn;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + this.jobId + "\n");
        sb.append("isWriteTxn: " + this.isWriteTxn + "\n");
        sb.append("firstLSN: " + this.firstLSN.get() + "\n");
        sb.append("lastLSN: " + this.lastLSN.get() + "\n");
        sb.append("TransactionState: " + this.txnState + "\n");
        sb.append("isTimeout: " + this.isTimeout + "\n");
        return sb.toString();
    }

    public LogRecord getLogRecord() {
        return this.logRecord;
    }

    public void cleanupForAbort() {
        if (this.primaryIndexOpTracker != null) {
            this.primaryIndexOpTracker.cleanupNumActiveOperationsForAbortedJob(this.transactorNumActiveOperations.get());
        }
    }

    public void incrementNumActiveOperations() {
        this.transactorNumActiveOperations.incrementAndGet();
    }

    public void decrementNumActiveOperations() {
        this.transactorNumActiveOperations.decrementAndGet();
    }
}

