/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.recovery.CheckpointThread;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractCheckpointManager
implements ICheckpointManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractCheckpointManager.class.getName());
    private static final String CHECKPOINT_FILENAME_PREFIX = "checkpoint_";
    public static final long SHARP_CHECKPOINT_LSN = -1L;
    private static final FilenameFilter filter = (dir, name) -> name.startsWith(CHECKPOINT_FILENAME_PREFIX);
    private final File checkpointDir;
    private final int historyToKeep;
    private final int lsnThreshold;
    private final int pollFrequency;
    protected final ITransactionSubsystem txnSubsystem;
    private CheckpointThread checkpointer;

    public AbstractCheckpointManager(ITransactionSubsystem txnSubsystem, CheckpointProperties checkpointProperties) {
        this.txnSubsystem = txnSubsystem;
        String checkpointDirPath = checkpointProperties.getCheckpointDirPath();
        if (!checkpointDirPath.endsWith(File.separator)) {
            checkpointDirPath = checkpointDirPath + File.separator;
        }
        this.checkpointDir = new File(checkpointDirPath);
        if (!this.checkpointDir.exists()) {
            new File(checkpointDirPath).mkdir();
        }
        this.lsnThreshold = checkpointProperties.getLsnThreshold();
        this.pollFrequency = checkpointProperties.getPollFrequency();
        this.historyToKeep = checkpointProperties.getHistoryToKeep() == 0 ? 1 : checkpointProperties.getHistoryToKeep();
    }

    public Checkpoint getLatest() throws ACIDException {
        File[] checkpoints = this.checkpointDir.listFiles(filter);
        if (checkpoints == null || checkpoints.length == 0) {
            return null;
        }
        ArrayList<Checkpoint> checkpointObjectList = new ArrayList<Checkpoint>();
        for (File file : checkpoints) {
            try {
                String jsonString = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                checkpointObjectList.add(Checkpoint.fromJson((String)jsonString));
            }
            catch (IOException e) {
                throw new ACIDException("Failed to read a checkpoint file", (Throwable)e);
            }
        }
        Collections.sort(checkpointObjectList);
        return (Checkpoint)checkpointObjectList.get(0);
    }

    public void start() {
        this.checkpointer = new CheckpointThread(this, this.txnSubsystem.getLogManager(), this.lsnThreshold, (long)this.pollFrequency);
        this.checkpointer.start();
    }

    public void stop(boolean dumpState, OutputStream ouputStream) throws IOException {
        this.checkpointer.shutdown();
        this.checkpointer.interrupt();
        try {
            this.checkpointer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void dumpState(OutputStream os) throws IOException {
    }

    protected void capture(long minMCTFirstLSN, boolean sharp) throws HyracksDataException {
        ILogManager logMgr = this.txnSubsystem.getLogManager();
        ITransactionManager txnMgr = this.txnSubsystem.getTransactionManager();
        Checkpoint checkpointObject = new Checkpoint(logMgr.getAppendLSN(), minMCTFirstLSN, txnMgr.getMaxJobId(), System.currentTimeMillis(), sharp, 6);
        this.persist(checkpointObject);
        this.cleanup();
    }

    private void persist(Checkpoint checkpoint) throws HyracksDataException {
        String fileName = this.checkpointDir.getAbsolutePath() + File.separator + CHECKPOINT_FILENAME_PREFIX + Long.toString(checkpoint.getTimeStamp());
        Path path = Paths.get(fileName, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(checkpoint.asJson());
        }
        catch (IOException e) {
            throw new HyracksDataException("Failed to write checkpoint to disk", (Throwable)e);
        }
    }

    private void cleanup() {
        Object[] checkpointFiles = this.checkpointDir.listFiles(filter);
        Arrays.sort(checkpointFiles);
        for (int i = 0; i < checkpointFiles.length - this.historyToKeep; ++i) {
            if (((File)checkpointFiles[i]).delete()) continue;
            LOGGER.warning("Could not delete checkpoint file at: " + ((File)checkpointFiles[i]).getAbsolutePath());
        }
    }
}

