/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.transaction.management.service.locking.ConcurrentLockManager;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

class ResourceGroup {
    private ReentrantReadWriteLock latch = new ReentrantReadWriteLock();
    private Condition condition = this.latch.writeLock().newCondition();
    AtomicLong firstResourceIndex = new AtomicLong(-1L);

    ResourceGroup() {
    }

    void getLatch() {
        this.log("latch");
        this.latch.writeLock().lock();
    }

    boolean tryLatch(long timeout, TimeUnit unit) throws InterruptedException {
        this.log("tryLatch");
        try {
            return this.latch.writeLock().tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            ConcurrentLockManager.LOGGER.finer("interrupted while wating on ResourceGroup");
            throw e;
        }
    }

    void releaseLatch() {
        this.log("release");
        this.latch.writeLock().unlock();
    }

    boolean hasWaiters() {
        return this.latch.hasQueuedThreads();
    }

    void await(ITransactionContext txnContext) throws InterruptedException {
        this.log("wait for");
        try {
            this.condition.await();
        }
        catch (InterruptedException e) {
            ConcurrentLockManager.LOGGER.finer("interrupted while waiting on ResourceGroup");
            throw e;
        }
    }

    void wakeUp() {
        this.log("notify");
        this.condition.signalAll();
    }

    void log(String s) {
        if (ConcurrentLockManager.LOGGER.isLoggable(ConcurrentLockManager.LVL)) {
            ConcurrentLockManager.LOGGER.log(ConcurrentLockManager.LVL, s + " " + this.toString());
        }
    }

    public String toString() {
        return "{ id : " + this.hashCode() + ", first : " + TypeUtil.Global.toString(this.firstResourceIndex.get()) + ", waiters : " + (this.hasWaiters() ? "true" : "false") + " }";
    }
}

