/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.ReplicationJob;
import org.apache.asterix.common.storage.IndexFileProperties;
import org.apache.asterix.common.transactions.Resource;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class PersistentLocalResourceRepository
implements ILocalResourceRepository {
    public static final String METADATA_FILE_NAME = ".metadata";
    private static final Logger LOGGER = Logger.getLogger(PersistentLocalResourceRepository.class.getName());
    private static final String STORAGE_METADATA_DIRECTORY = "root_metadata";
    private static final String STORAGE_METADATA_FILE_NAME_PREFIX = ".root_metadata";
    private static final long STORAGE_LOCAL_RESOURCE_ID = -4321L;
    private static final int MAX_CACHED_RESOURCES = 1000;
    private static final FilenameFilter METADATA_FILES_FILTER = (dir, name) -> name.equalsIgnoreCase(METADATA_FILE_NAME);
    private final IIOManager ioManager;
    private final String[] mountPoints;
    private final String nodeId;
    private final Cache<String, LocalResource> resourceCache;
    private final SortedMap<Integer, ClusterPartition> clusterPartitions;
    private final Set<Integer> nodeOriginalPartitions;
    private final Set<Integer> nodeActivePartitions;
    private boolean isReplicationEnabled = false;
    private Set<String> filesToBeReplicated;
    private IReplicationManager replicationManager;
    private Set<Integer> nodeInactivePartitions;

    public PersistentLocalResourceRepository(IIOManager ioManager, List<IODeviceHandle> devices, String nodeId, MetadataProperties metadataProperties) throws HyracksDataException {
        this.ioManager = ioManager;
        this.mountPoints = new String[devices.size()];
        this.nodeId = nodeId;
        this.clusterPartitions = metadataProperties.getClusterPartitions();
        for (int i = 0; i < this.mountPoints.length; ++i) {
            String mountPoint = devices.get(i).getMount().getPath();
            File mountPointDir = new File(mountPoint);
            if (!mountPointDir.exists()) {
                throw new HyracksDataException(mountPointDir.getAbsolutePath() + " doesn't exist.");
            }
            this.mountPoints[i] = !mountPoint.endsWith(File.separator) ? mountPoint + File.separator : mountPoint;
        }
        this.resourceCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        ClusterPartition[] nodePartitions = (ClusterPartition[])metadataProperties.getNodePartitions().get(nodeId);
        this.nodeOriginalPartitions = new HashSet<Integer>(nodePartitions.length);
        this.nodeActivePartitions = new HashSet<Integer>(nodePartitions.length);
        for (ClusterPartition partition : nodePartitions) {
            this.nodeOriginalPartitions.add(partition.getPartitionId());
            this.nodeActivePartitions.add(partition.getPartitionId());
        }
    }

    public String toString() {
        StringBuilder aString = new StringBuilder().append(PersistentLocalResourceRepository.class.getSimpleName()).append(13).append(this.ioManager.getClass().getSimpleName()).append(':').append(13).append(this.ioManager.toString()).append(13).append("Cached Resources:").append(13);
        for (Map.Entry pair : this.resourceCache.asMap().entrySet()) {
            aString.append((String)pair.getKey()).append("->").append(pair.getValue()).append(13);
        }
        return aString.toString();
    }

    public void initializeNewUniverse(String storageRootDirName) throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Initializing local resource repository ... ");
        }
        for (int i = 0; i < this.mountPoints.length; ++i) {
            FileReference storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(this.ioManager, this.nodeId, i);
            File storageMetadataDir = storageMetadataFile.getFile().getParentFile();
            boolean success = storageMetadataDir.mkdirs();
            if (!success) {
                throw new IllegalStateException("Unable to create storage metadata directory of PersistentLocalResourceRepository in " + storageMetadataDir.getAbsolutePath() + " or directory already exists");
            }
            LOGGER.log(Level.INFO, "created the root-metadata-file's directory: " + storageMetadataDir.getAbsolutePath());
            String storageRootDirPath = storageRootDirName.startsWith(File.separator) ? this.mountPoints[i] + storageRootDirName.substring(File.separator.length()) : this.mountPoints[i] + storageRootDirName;
            LocalResource rootLocalResource = new LocalResource(-4321L, storageMetadataFile.getRelativePath(), 0, 5, (Serializable)((Object)storageRootDirPath));
            this.insert(rootLocalResource);
            LOGGER.log(Level.INFO, "created the root-metadata-file: " + storageMetadataFile.getAbsolutePath());
        }
        LOGGER.log(Level.INFO, "Completed the initialization of the local resource repository");
    }

    public LocalResource get(String relativePath) throws HyracksDataException {
        FileReference resourceFile;
        LocalResource resource = (LocalResource)this.resourceCache.getIfPresent((Object)relativePath);
        if (resource == null && (resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath)).getFile().exists()) {
            resource = PersistentLocalResourceRepository.readLocalResource(resourceFile.getFile());
            this.resourceCache.put((Object)relativePath, (Object)resource);
        }
        return resource;
    }

    public synchronized void insert(LocalResource resource) throws HyracksDataException {
        String relativePath = PersistentLocalResourceRepository.getFileName(resource.getPath(), resource.getId());
        FileReference resourceFile = this.ioManager.resolve(relativePath);
        if (resourceFile.getFile().exists()) {
            throw new HyracksDataException("Duplicate resource: " + resourceFile.getAbsolutePath());
        }
        resourceFile.getFile().getParentFile().mkdirs();
        if (resource.getId() != -4321L) {
            this.resourceCache.put((Object)resource.getPath(), (Object)resource);
        }
        try (FileOutputStream fos = new FileOutputStream(resourceFile.getFile());
             ObjectOutputStream oosToFos = new ObjectOutputStream(fos);){
            oosToFos.writeObject(resource);
            oosToFos.flush();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        if (this.isReplicationEnabled && resource.getId() != -4321L) {
            this.createReplicationJob(IReplicationJob.ReplicationOperation.REPLICATE, resourceFile);
        }
    }

    public synchronized void delete(String relativePath) throws HyracksDataException {
        FileReference resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath);
        if (resourceFile.getFile().exists()) {
            resourceFile.delete();
            this.resourceCache.invalidate((Object)relativePath);
            if (this.isReplicationEnabled && !resourceFile.getFile().getName().startsWith(STORAGE_METADATA_FILE_NAME_PREFIX)) {
                this.createReplicationJob(IReplicationJob.ReplicationOperation.DELETE, resourceFile);
            }
        } else {
            throw new HyracksDataException("Resource doesn't exist");
        }
    }

    private static FileReference getLocalResourceFileByName(IIOManager ioManager, String resourcePath) throws HyracksDataException {
        String fileName = resourcePath + File.separator + METADATA_FILE_NAME;
        return ioManager.resolve(fileName);
    }

    public Map<Long, LocalResource> loadAndGetAllResources() throws HyracksDataException {
        HashMap<Long, LocalResource> resourcesMap = new HashMap<Long, LocalResource>();
        for (int i = 0; i < this.mountPoints.length; ++i) {
            File[] partitions;
            File storageRootDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageRootDir == null) continue;
            for (File partition : partitions = storageRootDir.listFiles()) {
                File[] dataverseFileList = partition.listFiles();
                if (dataverseFileList == null) continue;
                for (File dataverseFile : dataverseFileList) {
                    this.loadDataverse(dataverseFile, resourcesMap);
                }
            }
        }
        return resourcesMap;
    }

    private void loadDataverse(File dataverseFile, Map<Long, LocalResource> resourcesMap) throws HyracksDataException {
        File[] indexFileList;
        if (dataverseFile.isDirectory() && (indexFileList = dataverseFile.listFiles()) != null) {
            for (File indexFile : indexFileList) {
                this.loadIndex(indexFile, resourcesMap);
            }
        }
    }

    private void loadIndex(File indexFile, Map<Long, LocalResource> resourcesMap) throws HyracksDataException {
        File[] metadataFiles;
        if (indexFile.isDirectory() && (metadataFiles = indexFile.listFiles(METADATA_FILES_FILTER)) != null) {
            for (File metadataFile : metadataFiles) {
                LocalResource localResource = PersistentLocalResourceRepository.readLocalResource(metadataFile);
                resourcesMap.put(localResource.getId(), localResource);
            }
        }
    }

    public long maxId() throws HyracksDataException {
        long maxResourceId = 0L;
        for (int i = 0; i < this.mountPoints.length; ++i) {
            File[] partitions;
            File storageRootDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageRootDir == null) continue;
            for (File partition : partitions = storageRootDir.listFiles()) {
                File[] dataverseFileList = partition.listFiles();
                if (dataverseFileList == null) continue;
                for (File dataverseFile : dataverseFileList) {
                    maxResourceId = this.getMaxResourceIdForDataverse(dataverseFile, maxResourceId);
                }
            }
        }
        return maxResourceId;
    }

    private long getMaxResourceIdForDataverse(File dataverseFile, long maxSoFar) throws HyracksDataException {
        File[] indexFileList;
        long maxResourceId = maxSoFar;
        if (dataverseFile.isDirectory() && (indexFileList = dataverseFile.listFiles()) != null) {
            for (File indexFile : indexFileList) {
                maxResourceId = this.getMaxResourceIdForIndex(indexFile, maxResourceId);
            }
        }
        return maxResourceId;
    }

    private long getMaxResourceIdForIndex(File indexFile, long maxSoFar) throws HyracksDataException {
        File[] metadataFiles;
        long maxResourceId = maxSoFar;
        if (indexFile.isDirectory() && (metadataFiles = indexFile.listFiles(METADATA_FILES_FILTER)) != null) {
            for (File metadataFile : metadataFiles) {
                LocalResource localResource = PersistentLocalResourceRepository.readLocalResource(metadataFile);
                maxResourceId = Math.max(maxResourceId, localResource.getId());
            }
        }
        return maxResourceId;
    }

    private static String getFileName(String baseDir, long resourceId) {
        return resourceId == -4321L ? baseDir : (baseDir.endsWith(File.separator) ? baseDir + METADATA_FILE_NAME : baseDir + File.separator + METADATA_FILE_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalResource readLocalResource(File file) throws HyracksDataException {
        try (FileInputStream fis = new FileInputStream(file);){
            Throwable throwable;
            ObjectInputStream oisFromFis;
            block25: {
                LocalResource localResource;
                block26: {
                    oisFromFis = new ObjectInputStream(fis);
                    throwable = null;
                    LocalResource resource = (LocalResource)oisFromFis.readObject();
                    if (resource.getVersion() != 5) break block25;
                    localResource = resource;
                    if (oisFromFis == null) return localResource;
                    if (throwable == null) break block26;
                    try {
                        oisFromFis.close();
                        return localResource;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return localResource;
                    }
                }
                oisFromFis.close();
                return localResource;
            }
            try {
                try {
                    throw new AsterixException("Storage version mismatch.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (oisFromFis == null) throw throwable4;
                if (throwable == null) {
                    oisFromFis.close();
                    throw throwable4;
                }
                try {
                    oisFromFis.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.isReplicationEnabled = replicationManager.isReplicationEnabled();
        if (this.isReplicationEnabled) {
            this.filesToBeReplicated = new HashSet<String>();
            this.nodeInactivePartitions = ConcurrentHashMap.newKeySet();
        }
    }

    private void createReplicationJob(IReplicationJob.ReplicationOperation operation, FileReference fileRef) throws HyracksDataException {
        String[] fileNameTokens = fileRef.getAbsolutePath().split(File.separator);
        String partitionDir = fileNameTokens[fileNameTokens.length - 4];
        if (!partitionDir.equals("temp")) {
            this.filesToBeReplicated.clear();
            this.filesToBeReplicated.add(fileRef.getAbsolutePath());
            ReplicationJob job = new ReplicationJob(IReplicationJob.ReplicationJobType.METADATA, operation, IReplicationJob.ReplicationExecutionType.SYNC, this.filesToBeReplicated);
            try {
                this.replicationManager.submitJob((IReplicationJob)job);
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public String[] getStorageMountingPoints() {
        return this.mountPoints;
    }

    public void deleteStorageData(boolean deleteStorageMetadata) throws IOException {
        for (int i = 0; i < this.mountPoints.length; ++i) {
            FileReference storageMetadataFile;
            File storageMetadataDir;
            File storageDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageDir != null && storageDir.isDirectory()) {
                FileUtils.deleteDirectory((File)storageDir);
            }
            if (!deleteStorageMetadata || !(storageMetadataDir = (storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(this.ioManager, this.nodeId, i)).getFile().getParentFile().getParentFile()).exists() || !storageMetadataDir.isDirectory()) continue;
            FileUtils.deleteDirectory((File)storageMetadataDir);
        }
    }

    private static FileReference getStorageMetadataFile(IIOManager ioManager, String nodeId, int ioDeviceId) {
        String storageMetadataFileName = STORAGE_METADATA_DIRECTORY + File.separator + nodeId + "_iodevice" + ioDeviceId + File.separator + STORAGE_METADATA_FILE_NAME_PREFIX;
        return new FileReference((IODeviceHandle)ioManager.getIODevices().get(ioDeviceId), storageMetadataFileName);
    }

    public static File getStorageRootDirectoryIfExists(IIOManager ioManager, String nodeId, int ioDeviceId) throws HyracksDataException {
        LocalResource rootLocalResource;
        String storageRootDirPath;
        Path path;
        File storageRootDir = null;
        FileReference storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(ioManager, nodeId, ioDeviceId);
        if (storageMetadataFile.getFile().exists() && Files.exists(path = Paths.get(storageRootDirPath = (String)((Object)(rootLocalResource = PersistentLocalResourceRepository.readLocalResource(storageMetadataFile.getFile())).getResource()), new String[0]), new LinkOption[0])) {
            storageRootDir = new File(storageRootDirPath);
        }
        return storageRootDir;
    }

    public String getPartitionPath(int partition) {
        return this.mountPoints[this.getIODeviceNum(partition)];
    }

    public int getIODeviceNum(int partition) {
        return ((ClusterPartition)this.clusterPartitions.get(partition)).getIODeviceNum();
    }

    public Set<Integer> getActivePartitions() {
        return Collections.unmodifiableSet(this.nodeActivePartitions);
    }

    public Set<Integer> getInactivePartitions() {
        return Collections.unmodifiableSet(this.nodeInactivePartitions);
    }

    public Set<Integer> getNodeOrignalPartitions() {
        return Collections.unmodifiableSet(this.nodeOriginalPartitions);
    }

    public synchronized void addActivePartition(int partitonId) {
        this.nodeActivePartitions.add(partitonId);
        this.nodeInactivePartitions.remove(partitonId);
    }

    public synchronized void addInactivePartition(int partitonId) {
        this.nodeInactivePartitions.add(partitonId);
        this.nodeActivePartitions.remove(partitonId);
    }

    private static String getLocalResourceRelativePath(String absolutePath) {
        String[] tokens = absolutePath.split(File.separator);
        return tokens[tokens.length - 5] + File.separator + tokens[tokens.length - 4] + File.separator + tokens[tokens.length - 3] + File.separator + tokens[tokens.length - 2];
    }

    public IndexFileProperties getIndexFileRef(String absoluteFilePath) throws HyracksDataException {
        String[] tokens = absoluteFilePath.split(File.separator);
        if (tokens.length < 5) {
            throw new HyracksDataException("Invalid file format");
        }
        String fileName = tokens[tokens.length - 1];
        String index = tokens[tokens.length - 2];
        String dataverse = tokens[tokens.length - 3];
        String partition = tokens[tokens.length - 4];
        int partitionId = StoragePathUtil.getPartitionNumFromName((String)partition);
        String relativePath = PersistentLocalResourceRepository.getLocalResourceRelativePath(absoluteFilePath);
        LocalResource lr = this.get(relativePath);
        int datasetId = lr == null ? -1 : ((Resource)lr.getResource()).datasetId();
        return new IndexFileProperties(partitionId, dataverse, index, fileName, datasetId);
    }
}

