/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.transactions.Resource;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.LocalResource;

public class LSMInvertedIndexLocalResourceMetadata
extends Resource {
    private static final long serialVersionUID = 1L;
    private final ITypeTraits[] invListTypeTraits;
    private final IBinaryComparatorFactory[] invListCmpFactories;
    private final ITypeTraits[] tokenTypeTraits;
    private final IBinaryComparatorFactory[] tokenCmpFactories;
    private final IBinaryTokenizerFactory tokenizerFactory;
    private final boolean isPartitioned;
    private final ILSMMergePolicyFactory mergePolicyFactory;
    private final Map<String, String> mergePolicyProperties;
    private final int[] invertedIndexFields;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;

    public LSMInvertedIndexLocalResourceMetadata(ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, boolean isPartitioned, int datasetID, int partition, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] invertedIndexFields, int[] filterFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory) {
        super(datasetID, partition, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, metadataPageManagerFactory);
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
        this.isPartitioned = isPartitioned;
        this.mergePolicyFactory = mergePolicyFactory;
        this.mergePolicyProperties = mergePolicyProperties;
        this.invertedIndexFields = invertedIndexFields;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
    }

    public ILSMIndex createIndexInstance(INCServiceContext serviceCtx, LocalResource resource) throws HyracksDataException {
        IAppRuntimeContext appCtx = (IAppRuntimeContext)serviceCtx.getApplicationContext();
        IIOManager ioManager = appCtx.getIOManager();
        FileReference file = ioManager.resolve(resource.getPath());
        int ioDeviceNum = Resource.getIoDeviceNum((IIOManager)ioManager, (IODeviceHandle)file.getDeviceHandle());
        List virtualBufferCaches = appCtx.getDatasetLifecycleManager().getVirtualBufferCaches(this.datasetId(), ioDeviceNum);
        try {
            if (this.isPartitioned) {
                return InvertedIndexUtils.createPartitionedLSMInvertedIndex((IIOManager)ioManager, (List)virtualBufferCaches, (IFileMapProvider)appCtx.getFileMapManager(), (ITypeTraits[])this.invListTypeTraits, (IBinaryComparatorFactory[])this.invListCmpFactories, (ITypeTraits[])this.tokenTypeTraits, (IBinaryComparatorFactory[])this.tokenCmpFactories, (IBinaryTokenizerFactory)this.tokenizerFactory, (IBufferCache)appCtx.getBufferCache(), (String)file.getAbsolutePath(), (double)appCtx.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, (IResourceLifecycleManager)appCtx.getDatasetLifecycleManager()), (ILSMOperationTracker)this.opTrackerProvider.getOperationTracker(serviceCtx), (ILSMIOOperationScheduler)appCtx.getLSMIOScheduler(), (ILSMIOOperationCallback)this.ioOpCallbackFactory.createIoOpCallback(), (int[])this.invertedIndexFields, (ITypeTraits[])this.filterTypeTraits, (IBinaryComparatorFactory[])this.filterCmpFactories, (int[])this.filterFields, (int[])this.filterFieldsForNonBulkLoadOps, (int[])this.invertedIndexFieldsForNonBulkLoadOps, (boolean)true, (IPageManagerFactory)this.metadataPageManagerFactory);
            }
            return InvertedIndexUtils.createLSMInvertedIndex((IIOManager)ioManager, (List)virtualBufferCaches, (IFileMapProvider)appCtx.getFileMapManager(), (ITypeTraits[])this.invListTypeTraits, (IBinaryComparatorFactory[])this.invListCmpFactories, (ITypeTraits[])this.tokenTypeTraits, (IBinaryComparatorFactory[])this.tokenCmpFactories, (IBinaryTokenizerFactory)this.tokenizerFactory, (IBufferCache)appCtx.getBufferCache(), (String)file.getAbsolutePath(), (double)appCtx.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, (IResourceLifecycleManager)appCtx.getDatasetLifecycleManager()), (ILSMOperationTracker)this.opTrackerProvider.getOperationTracker(serviceCtx), (ILSMIOOperationScheduler)appCtx.getLSMIOScheduler(), (ILSMIOOperationCallback)this.ioOpCallbackFactory.createIoOpCallback(), (int[])this.invertedIndexFields, (ITypeTraits[])this.filterTypeTraits, (IBinaryComparatorFactory[])this.filterCmpFactories, (int[])this.filterFields, (int[])this.filterFieldsForNonBulkLoadOps, (int[])this.invertedIndexFieldsForNonBulkLoadOps, (boolean)true, (IMetadataPageManagerFactory)this.metadataPageManagerFactory);
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

