/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.transactions.Resource;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.lsm.btree.utils.LSMBTreeUtil;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.LocalResource;

public class LSMBTreeLocalResourceMetadata
extends Resource {
    private static final long serialVersionUID = 1L;
    protected final ITypeTraits[] typeTraits;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final int[] bloomFilterKeyFields;
    protected final boolean isPrimary;
    protected final ILSMMergePolicyFactory mergePolicyFactory;
    protected final Map<String, String> mergePolicyProperties;
    protected final int[] btreeFields;

    public LSMBTreeLocalResourceMetadata(ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, boolean isPrimary, int datasetID, int partition, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] btreeFields, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory) {
        super(datasetID, partition, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, metadataPageManagerFactory);
        this.typeTraits = typeTraits;
        this.cmpFactories = cmpFactories;
        this.bloomFilterKeyFields = bloomFilterKeyFields;
        this.isPrimary = isPrimary;
        this.mergePolicyFactory = mergePolicyFactory;
        this.mergePolicyProperties = mergePolicyProperties;
        this.btreeFields = btreeFields;
    }

    public String toString() {
        return " { \"" + LSMBTreeLocalResourceMetadata.class.getName() + "\" : {" + "\"datasetId\" : " + this.datasetId() + ", \"partition\" : " + this.partition() + " } " + " }";
    }

    public ILSMIndex createIndexInstance(INCServiceContext serviceCtx, LocalResource resource) throws HyracksDataException {
        IAppRuntimeContext appCtx = (IAppRuntimeContext)serviceCtx.getApplicationContext();
        IIOManager ioManager = appCtx.getIOManager();
        FileReference file = ioManager.resolve(resource.getPath());
        int ioDeviceNum = Resource.getIoDeviceNum((IIOManager)ioManager, (IODeviceHandle)file.getDeviceHandle());
        IDatasetLifecycleManager datasetLifecycleManager = appCtx.getDatasetLifecycleManager();
        return LSMBTreeUtil.createLSMTree((IIOManager)ioManager, (List)datasetLifecycleManager.getVirtualBufferCaches(this.datasetId(), ioDeviceNum), (FileReference)file, (IBufferCache)appCtx.getBufferCache(), (IFileMapProvider)appCtx.getFileMapManager(), (ITypeTraits[])this.typeTraits, (IBinaryComparatorFactory[])this.cmpFactories, (int[])this.bloomFilterKeyFields, (double)appCtx.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, (IResourceLifecycleManager)datasetLifecycleManager), (ILSMOperationTracker)this.opTrackerProvider.getOperationTracker(serviceCtx), (ILSMIOOperationScheduler)appCtx.getLSMIOScheduler(), (ILSMIOOperationCallback)this.ioOpCallbackFactory.createIoOpCallback(), (boolean)this.isPrimary, (ITypeTraits[])this.filterTypeTraits, (IBinaryComparatorFactory[])this.filterCmpFactories, (int[])this.btreeFields, (int[])this.filterFields, (boolean)true, (IMetadataPageManagerFactory)this.metadataPageManagerFactory);
    }
}

