/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.exceptions.OccurrenceThresholdPanicException;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.AbstractTOccurrenceSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;

public class TOccurrenceSearcher
extends AbstractTOccurrenceSearcher {
    protected final ArrayList<IInvertedListCursor> invListCursors = new ArrayList();

    public TOccurrenceSearcher(IHyracksCommonContext ctx, IInvertedIndex invIndex) throws HyracksDataException {
        super(ctx, invIndex);
    }

    @Override
    public void search(OnDiskInvertedIndexSearchCursor resultCursor, InvertedIndexSearchPredicate searchPred, IIndexOperationContext ictx) throws HyracksDataException, IndexException {
        this.tokenizeQuery(searchPred);
        int numQueryTokens = this.queryTokenAppender.getTupleCount();
        this.invListCursors.clear();
        this.invListCursorCache.reset();
        for (int i = 0; i < numQueryTokens; ++i) {
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, i);
            IInvertedListCursor invListCursor = (IInvertedListCursor)this.invListCursorCache.getNext();
            this.invIndex.openInvertedListCursor(invListCursor, (ITupleReference)this.searchKey, ictx);
            this.invListCursors.add(invListCursor);
        }
        IInvertedIndexSearchModifier searchModifier = searchPred.getSearchModifier();
        this.occurrenceThreshold = searchModifier.getOccurrenceThreshold(numQueryTokens);
        if (this.occurrenceThreshold <= 0) {
            throw new OccurrenceThresholdPanicException("Merge threshold is <= 0. Failing Search.");
        }
        int numPrefixLists = searchModifier.getNumPrefixLists(this.occurrenceThreshold, this.invListCursors.size());
        this.searchResult.reset();
        this.invListMerger.merge(this.invListCursors, this.occurrenceThreshold, numPrefixLists, this.searchResult);
        resultCursor.open(null, (ISearchPredicate)searchPred);
    }
}

