/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexNonExistentKeyException;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class InMemoryInvertedIndex
implements IInvertedIndex {
    protected final BTree btree;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final IBinaryTokenizerFactory tokenizerFactory;
    protected final ITypeTraits[] btreeTypeTraits;
    protected final IBinaryComparatorFactory[] btreeCmpFactories;

    public InMemoryInvertedIndex(IBufferCache virtualBufferCache, IPageManager virtualFreePageManager, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, FileReference btreeFileRef) throws HyracksDataException {
        int i;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
        int numBTreeFields = tokenTypeTraits.length + invListTypeTraits.length;
        this.btreeTypeTraits = new ITypeTraits[numBTreeFields];
        this.btreeCmpFactories = new IBinaryComparatorFactory[numBTreeFields];
        for (i = 0; i < tokenTypeTraits.length; ++i) {
            this.btreeTypeTraits[i] = tokenTypeTraits[i];
            this.btreeCmpFactories[i] = tokenCmpFactories[i];
        }
        for (i = 0; i < invListTypeTraits.length; ++i) {
            this.btreeTypeTraits[tokenTypeTraits.length + i] = invListTypeTraits[i];
            this.btreeCmpFactories[tokenTypeTraits.length + i] = invListCmpFactories[i];
        }
        this.btree = BTreeUtils.createBTree((IBufferCache)virtualBufferCache, (IPageManager)virtualFreePageManager, (IFileMapProvider)((IVirtualBufferCache)virtualBufferCache).getFileMapProvider(), (ITypeTraits[])this.btreeTypeTraits, (IBinaryComparatorFactory[])this.btreeCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)btreeFileRef);
    }

    public void create() throws HyracksDataException {
        this.btree.create();
    }

    public void activate() throws HyracksDataException {
        this.btree.activate();
    }

    public void clear() throws HyracksDataException {
        this.btree.clear();
    }

    public void deactivate() throws HyracksDataException {
        this.btree.deactivate();
    }

    public void destroy() throws HyracksDataException {
        this.btree.destroy();
    }

    public void validate() throws HyracksDataException {
        this.btree.validate();
    }

    public void insert(ITupleReference tuple, BTree.BTreeAccessor btreeAccessor, IIndexOperationContext ictx) throws HyracksDataException, IndexException {
        InMemoryInvertedIndexOpContext ctx = (InMemoryInvertedIndexOpContext)ictx;
        ctx.tupleIter.reset(tuple);
        while (ctx.tupleIter.hasNext()) {
            ctx.tupleIter.next();
            ITupleReference insertTuple = ctx.tupleIter.getTuple();
            try {
                btreeAccessor.insert(insertTuple);
            }
            catch (TreeIndexDuplicateKeyException treeIndexDuplicateKeyException) {}
        }
    }

    public void delete(ITupleReference tuple, BTree.BTreeAccessor btreeAccessor, IIndexOperationContext ictx) throws HyracksDataException, IndexException {
        InMemoryInvertedIndexOpContext ctx = (InMemoryInvertedIndexOpContext)ictx;
        ctx.tupleIter.reset(tuple);
        while (ctx.tupleIter.hasNext()) {
            ctx.tupleIter.next();
            ITupleReference deleteTuple = ctx.tupleIter.getTuple();
            try {
                btreeAccessor.delete(deleteTuple);
            }
            catch (TreeIndexNonExistentKeyException treeIndexNonExistentKeyException) {}
        }
    }

    public long getMemoryAllocationSize() {
        IBufferCache virtualBufferCache = this.btree.getBufferCache();
        return virtualBufferCache.getNumPages() * virtualBufferCache.getPageSize();
    }

    @Override
    public IInvertedListCursor createInvertedListCursor() {
        return new InMemoryInvertedListCursor(this.invListTypeTraits.length, this.tokenTypeTraits.length);
    }

    @Override
    public void openInvertedListCursor(IInvertedListCursor listCursor, ITupleReference searchKey, IIndexOperationContext ictx) throws HyracksDataException, IndexException {
        InMemoryInvertedIndexOpContext ctx = (InMemoryInvertedIndexOpContext)ictx;
        ctx.setOperation(IndexOperation.SEARCH);
        InMemoryInvertedListCursor inMemListCursor = (InMemoryInvertedListCursor)listCursor;
        inMemListCursor.prepare(ctx.btreeAccessor, ctx.btreePred, ctx.tokenFieldsCmp, ctx.btreeCmp);
        inMemListCursor.reset(searchKey);
    }

    public IIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new InMemoryInvertedIndexAccessor(this, new InMemoryInvertedIndexOpContext(this.btree, this.tokenCmpFactories, this.tokenizerFactory));
    }

    public IBufferCache getBufferCache() {
        return this.btree.getBufferCache();
    }

    public BTree getBTree() {
        return this.btree;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws IndexException {
        throw new UnsupportedOperationException("Bulk load not supported by in-memory inverted index.");
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public boolean hasMemoryComponents() {
        return true;
    }
}

