/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;

public class LSMInvertedIndexMergeOperation
implements ILSMIOOperation {
    private final ILSMIndexAccessor accessor;
    private final List<ILSMComponent> mergingComponents;
    private final IIndexCursor cursor;
    private final FileReference dictBTreeMergeTarget;
    private final FileReference deletedKeysBTreeMergeTarget;
    private final FileReference bloomFilterMergeTarget;
    private final ILSMIOOperationCallback callback;
    private final String indexIdentifier;

    public LSMInvertedIndexMergeOperation(ILSMIndexAccessor accessor, List<ILSMComponent> mergingComponents, IIndexCursor cursor, FileReference dictBTreeMergeTarget, FileReference deletedKeysBTreeMergeTarget, FileReference bloomFilterMergeTarget, ILSMIOOperationCallback callback, String indexIdentifier) {
        this.accessor = accessor;
        this.mergingComponents = mergingComponents;
        this.cursor = cursor;
        this.dictBTreeMergeTarget = dictBTreeMergeTarget;
        this.deletedKeysBTreeMergeTarget = deletedKeysBTreeMergeTarget;
        this.bloomFilterMergeTarget = bloomFilterMergeTarget;
        this.callback = callback;
        this.indexIdentifier = indexIdentifier;
    }

    public Set<IODeviceHandle> getReadDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        for (ILSMComponent o : this.mergingComponents) {
            LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)o;
            OnDiskInvertedIndex invIndex = (OnDiskInvertedIndex)component.getInvIndex();
            devs.add(invIndex.getBTree().getFileReference().getDeviceHandle());
            devs.add(component.getDeletedKeysBTree().getFileReference().getDeviceHandle());
            devs.add(component.getBloomFilter().getFileReference().getDeviceHandle());
        }
        return devs;
    }

    public Set<IODeviceHandle> getWriteDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        devs.add(this.dictBTreeMergeTarget.getDeviceHandle());
        devs.add(this.deletedKeysBTreeMergeTarget.getDeviceHandle());
        devs.add(this.bloomFilterMergeTarget.getDeviceHandle());
        return devs;
    }

    public Boolean call() throws HyracksDataException, IndexException {
        this.accessor.merge((ILSMIOOperation)this);
        return true;
    }

    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    public FileReference getDictBTreeMergeTarget() {
        return this.dictBTreeMergeTarget;
    }

    public FileReference getDeletedKeysBTreeMergeTarget() {
        return this.deletedKeysBTreeMergeTarget;
    }

    public FileReference getBloomFilterMergeTarget() {
        return this.bloomFilterMergeTarget;
    }

    public IIndexCursor getCursor() {
        return this.cursor;
    }

    public List<ILSMComponent> getMergingComponents() {
        return this.mergingComponents;
    }

    public String getIndexUniqueIdentifier() {
        return this.indexIdentifier;
    }

    public ILSMIOOperation.LSMIOOpertionType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOpertionType.MERGE;
    }
}

