/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexFileNameMapper;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMInvertedIndexFileManager
extends AbstractLSMIndexFileManager
implements IInvertedIndexFileNameMapper {
    public static final String DICT_BTREE_SUFFIX = "b";
    public static final String INVLISTS_SUFFIX = "i";
    public static final String DELETED_KEYS_BTREE_SUFFIX = "d";
    private final BTreeFactory btreeFactory;
    private static FilenameFilter dictBTreeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMInvertedIndexFileManager.DICT_BTREE_SUFFIX);
        }
    };
    private static FilenameFilter invListFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMInvertedIndexFileManager.INVLISTS_SUFFIX);
        }
    };
    private static FilenameFilter deletedKeysBTreeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMInvertedIndexFileManager.DELETED_KEYS_BTREE_SUFFIX);
        }
    };

    public LSMInvertedIndexFileManager(IIOManager ioManager, IFileMapProvider fileMapProvider, FileReference file, BTreeFactory btreeFactory) {
        super(ioManager, fileMapProvider, file, null);
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        String baseName = this.baseDir + ts + "_" + ts;
        return new LSMComponentFileReferences(this.createFlushFile(baseName + "_" + DICT_BTREE_SUFFIX), this.createFlushFile(baseName + "_" + DELETED_KEYS_BTREE_SUFFIX), this.createFlushFile(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split("_");
        String[] lastTimestampRange = lastFileName.split("_");
        String baseName = this.baseDir + firstTimestampRange[0] + "_" + lastTimestampRange[1];
        return new LSMComponentFileReferences(this.createMergeFile(baseName + "_" + DICT_BTREE_SUFFIX), this.createMergeFile(baseName + "_" + DELETED_KEYS_BTREE_SUFFIX), this.createMergeFile(baseName + "_" + "f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException, IndexException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allDictBTreeFiles = new ArrayList();
        ArrayList allInvListsFiles = new ArrayList();
        ArrayList allDeletedKeysBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        this.cleanupAndGetValidFilesInternal(deletedKeysBTreeFilter, (TreeIndexFactory)this.btreeFactory, allDeletedKeysBTreeFiles);
        HashSet<String> deletedKeysBTreeFilesSet = new HashSet<String>();
        for (AbstractLSMIndexFileManager.ComparableFileName cmpFileName : allDeletedKeysBTreeFiles) {
            int index = cmpFileName.fileName.lastIndexOf("_");
            deletedKeysBTreeFilesSet.add(cmpFileName.fileName.substring(0, index));
        }
        this.validateFiles(deletedKeysBTreeFilesSet, allInvListsFiles, invListFilter, null);
        this.validateFiles(deletedKeysBTreeFilesSet, allDictBTreeFiles, dictBTreeFilter, (TreeIndexFactory)this.btreeFactory);
        this.validateFiles(deletedKeysBTreeFilesSet, allBloomFilterFiles, bloomFilterFilter, null);
        if (allDictBTreeFiles.size() != allInvListsFiles.size() || allDictBTreeFiles.size() != allDeletedKeysBTreeFiles.size() || allDictBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw new HyracksDataException("Unequal number of valid Dictionary BTree, Inverted Lists, Deleted BTree, and Bloom Filter files found. Aborting cleanup.");
        }
        if (allDictBTreeFiles.isEmpty() || allInvListsFiles.isEmpty() || allDeletedKeysBTreeFiles.isEmpty() || allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (allDictBTreeFiles.size() == 1 && allInvListsFiles.size() == 1 && allDeletedKeysBTreeFiles.size() == 1 && allBloomFilterFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((AbstractLSMIndexFileManager.ComparableFileName)allDictBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allDeletedKeysBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get((int)0)).fileRef));
            return validFiles;
        }
        Collections.sort(allDeletedKeysBTreeFiles);
        Collections.sort(allDictBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableDictBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastDictBTree = (AbstractLSMIndexFileManager.ComparableFileName)allDictBTreeFiles.get(0);
        validComparableDictBTreeFiles.add(lastDictBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableDeletedKeysBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastDeletedKeysBTree = (AbstractLSMIndexFileManager.ComparableFileName)allDeletedKeysBTreeFiles.get(0);
        validComparableDeletedKeysBTreeFiles.add(lastDeletedKeysBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBloomFilterFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allDictBTreeFiles.size(); ++i) {
            AbstractLSMIndexFileManager.ComparableFileName currentDeletedKeysBTree = (AbstractLSMIndexFileManager.ComparableFileName)allDeletedKeysBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName CurrentDictBTree = (AbstractLSMIndexFileManager.ComparableFileName)allDictBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName currentBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(i);
            if (currentDeletedKeysBTree.interval[0].compareTo(lastDeletedKeysBTree.interval[1]) > 0 && CurrentDictBTree.interval[0].compareTo(lastDictBTree.interval[1]) > 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[1]) > 0) {
                validComparableDictBTreeFiles.add(CurrentDictBTree);
                validComparableDeletedKeysBTreeFiles.add(currentDeletedKeysBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastDictBTree = CurrentDictBTree;
                lastDeletedKeysBTree = currentDeletedKeysBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentDeletedKeysBTree.interval[0].compareTo(lastDeletedKeysBTree.interval[0]) >= 0 && currentDeletedKeysBTree.interval[1].compareTo(lastDeletedKeysBTree.interval[1]) <= 0 && CurrentDictBTree.interval[0].compareTo(lastDictBTree.interval[0]) >= 0 && CurrentDictBTree.interval[1].compareTo(lastDictBTree.interval[1]) <= 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[0]) >= 0 && currentBloomFilter.interval[1].compareTo(lastBloomFilter.interval[1]) <= 0) {
                File invalidDeletedBTreeFile = new File(currentDeletedKeysBTree.fullPath);
                invalidDeletedBTreeFile.delete();
                File invalidDictBTreeFile = new File(CurrentDictBTree.fullPath);
                invalidDictBTreeFile.delete();
                File invalidBloomFilterFile = new File(currentBloomFilter.fullPath);
                invalidBloomFilterFile.delete();
                continue;
            }
            throw new HyracksDataException("Found LSM files with overlapping but not contained timetamp intervals.");
        }
        Collections.sort(validComparableDictBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableDeletedKeysBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
        Iterator dictBTreeFileIter = validComparableDictBTreeFiles.iterator();
        Iterator deletedKeysBTreeIter = validComparableDeletedKeysBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (dictBTreeFileIter.hasNext() && deletedKeysBTreeIter.hasNext()) {
            AbstractLSMIndexFileManager.ComparableFileName cmpDictBTreeFile = (AbstractLSMIndexFileManager.ComparableFileName)dictBTreeFileIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpDeletedKeysBTreeFile = (AbstractLSMIndexFileManager.ComparableFileName)deletedKeysBTreeIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpBloomFilterFileName = (AbstractLSMIndexFileManager.ComparableFileName)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpDictBTreeFile.fileRef, cmpDeletedKeysBTreeFile.fileRef, cmpBloomFilterFileName.fileRef));
        }
        return validFiles;
    }

    @Override
    public String getInvListsFilePath(String dictBTreeFilePath) {
        int index = dictBTreeFilePath.lastIndexOf("_");
        String file = dictBTreeFilePath.substring(0, index);
        return file + "_" + INVLISTS_SUFFIX;
    }
}

