/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.AbstractLSMInvertedIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;

public class LSMInvertedIndexSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected final IInvertedIndexSearchModifier searchModifier;
    protected final int queryFieldIndex;
    protected final int invListFields;
    protected final boolean isFullTextSearchQuery;

    public LSMInvertedIndexSearchOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider, int queryFieldIndex, IInvertedIndexSearchModifier searchModifier, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, boolean isFullTextSearchQuery) throws HyracksDataException {
        super(opDesc, ctx, partition, recordDescProvider, minFilterFieldIndexes, maxFilterFieldIndexes);
        this.searchModifier = searchModifier;
        this.queryFieldIndex = queryFieldIndex;
        this.isFullTextSearchQuery = isFullTextSearchQuery;
        if (!opDesc.getRetainInput()) {
            this.frameTuple = new FrameTupleReference();
        }
        AbstractLSMInvertedIndexOperatorDescriptor invIndexOpDesc = (AbstractLSMInvertedIndexOperatorDescriptor)opDesc;
        this.invListFields = invIndexOpDesc.getInvListsTypeTraits().length;
    }

    protected ISearchPredicate createSearchPredicate() {
        AbstractLSMInvertedIndexOperatorDescriptor invIndexOpDesc = (AbstractLSMInvertedIndexOperatorDescriptor)this.opDesc;
        return new InvertedIndexSearchPredicate(invIndexOpDesc.getTokenizerFactory().createTokenizer(), this.searchModifier, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey, this.isFullTextSearchQuery);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        InvertedIndexSearchPredicate invIndexSearchPred = (InvertedIndexSearchPredicate)this.searchPred;
        invIndexSearchPred.setQueryTuple((ITupleReference)this.frameTuple);
        invIndexSearchPred.setQueryFieldIndex(this.queryFieldIndex);
        invIndexSearchPred.setIsFullTextSearchQuery(this.isFullTextSearchQuery);
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected int getFieldCount() {
        return this.invListFields;
    }
}

